/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.iosource;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.tools.iosource.OutputResource;
import schemacrawler.tools.iosource.OutputWriter;
import sf.util.SchemaCrawlerLogger;

public class WriterOutputResource
implements OutputResource {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(WriterOutputResource.class.getName());
    private final Writer writer;

    public WriterOutputResource(Writer writer) {
        this.writer = Objects.requireNonNull(writer, "No writer provided");
    }

    @Override
    public Writer openNewOutputWriter(Charset charset, boolean appendOutput) throws IOException {
        LOGGER.log(Level.INFO, "Output to provided writer");
        return new OutputWriter(this.getDescription(), new BufferedWriter(this.writer), false);
    }

    public String toString() {
        return "<writer>";
    }
}

