/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.Options;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.CompressedFileInputResource;
import schemacrawler.tools.iosource.CompressedFileOutputResource;
import schemacrawler.tools.iosource.ConsoleOutputResource;
import schemacrawler.tools.iosource.FileInputResource;
import schemacrawler.tools.iosource.FileOutputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.iosource.OutputResource;
import schemacrawler.tools.iosource.WriterOutputResource;
import schemacrawler.tools.options.OutputFormat;
import sf.util.ObjectToString;
import sf.util.Utility;

public class OutputOptions
implements Options {
    private static final String SCHEMACRAWLER_DATA = "schemacrawler.data";
    private static final String SC_INPUT_ENCODING = "schemacrawler.encoding.input";
    private static final String SC_OUTPUT_ENCODING = "schemacrawler.encoding.output";
    private OutputResource outputResource;
    private InputResource inputResource;
    private String outputFormatValue;
    private Charset inputEncodingCharset;
    private Charset outputEncodingCharset;

    public OutputOptions() {
    }

    public OutputOptions(Config config) {
        Config configProperties = config == null ? new Config() : config;
        this.setInputEncoding(configProperties.getStringValue(SC_INPUT_ENCODING, StandardCharsets.UTF_8.name()));
        this.setOutputEncoding(configProperties.getStringValue(SC_OUTPUT_ENCODING, StandardCharsets.UTF_8.name()));
    }

    public OutputOptions(OutputFormat outputFormat, Path outputFile) {
        this(Objects.requireNonNull(outputFormat, "No output format provided").getFormat(), outputFile);
    }

    public OutputOptions(OutputFormat outputFormat, Writer writer) {
        this(Objects.requireNonNull(outputFormat, "No output format provided").getFormat(), writer);
    }

    public OutputOptions(String outputFormatValue) {
        this.outputFormatValue = Objects.requireNonNull(outputFormatValue, "No output format value provided");
        this.setConsoleOutput();
    }

    public OutputOptions(String outputFormatValue, Path outputFile) {
        this.outputFormatValue = Objects.requireNonNull(outputFormatValue, "No output format value provided");
        this.setOutputFile(outputFile);
    }

    public OutputOptions(String outputFormatValue, Writer writer) {
        this.outputFormatValue = Objects.requireNonNull(outputFormatValue, "No output format value provided");
        this.setWriter(writer);
    }

    public void forceCompressedOutputFile() throws IOException {
        if (!(this.outputResource instanceof CompressedFileOutputResource)) {
            Path outputFile = this.getOutputFile();
            this.outputResource = new CompressedFileOutputResource(outputFile, SCHEMACRAWLER_DATA);
        }
    }

    public void forceOutputFile() {
        if (!(this.outputResource instanceof FileOutputResource)) {
            Path outputFile = this.getOutputFile();
            this.outputResource = new FileOutputResource(outputFile);
        }
    }

    public Charset getInputCharset() {
        if (this.inputEncodingCharset == null) {
            return StandardCharsets.UTF_8;
        }
        return this.inputEncodingCharset;
    }

    public Charset getOutputCharset() {
        if (this.outputEncodingCharset == null) {
            return StandardCharsets.UTF_8;
        }
        return this.outputEncodingCharset;
    }

    public Path getOutputFile() {
        Path outputFile;
        if (this.outputResource instanceof FileOutputResource) {
            outputFile = ((FileOutputResource)this.outputResource).getOutputFile();
        } else if (this.outputResource instanceof CompressedFileOutputResource) {
            outputFile = ((CompressedFileOutputResource)this.outputResource).getOutputFile();
        } else {
            String extension = "htmlx".equals(this.outputFormatValue) ? "svg.html" : this.outputFormatValue;
            outputFile = Paths.get(".", String.format("schemacrawler-%s.%s", UUID.randomUUID(), extension)).normalize().toAbsolutePath();
        }
        return outputFile;
    }

    public String getOutputFormatValue() {
        return this.outputFormatValue;
    }

    public Reader openNewInputReader() throws IOException {
        this.obtainInputResource();
        if (this.inputResource == null) {
            throw new IOException("Cannot read " + this.outputFormatValue);
        }
        return this.inputResource.openNewInputReader(this.getInputCharset());
    }

    public Writer openNewOutputWriter() throws IOException {
        return this.openNewOutputWriter(false);
    }

    public Writer openNewOutputWriter(boolean appendOutput) throws IOException {
        this.obtainOutputResource();
        return this.outputResource.openNewOutputWriter(this.getOutputCharset(), appendOutput);
    }

    public void setCompressedInputFile(Path inputFile) throws IOException {
        Objects.requireNonNull(inputFile, "No input file provided");
        this.inputResource = new CompressedFileInputResource(inputFile, SCHEMACRAWLER_DATA);
    }

    public void setCompressedOutputFile(Path outputFile) throws IOException {
        Objects.requireNonNull(outputFile, "No output file provided");
        this.outputResource = new CompressedFileOutputResource(outputFile, SCHEMACRAWLER_DATA);
    }

    public void setConsoleOutput() {
        this.outputResource = new ConsoleOutputResource();
    }

    public void setInputEncoding(Charset inputCharset) {
        this.inputEncodingCharset = inputCharset == null ? StandardCharsets.UTF_8 : inputCharset;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncodingCharset = Utility.isBlank(inputEncoding) ? StandardCharsets.UTF_8 : Charset.forName(inputEncoding);
    }

    public void setInputFile(Path inputFile) throws IOException {
        Objects.requireNonNull(inputFile, "No input file provided");
        this.inputResource = new FileInputResource(inputFile);
    }

    public void setInputResource(InputResource inputResource) {
        this.inputResource = inputResource;
    }

    public void setInputResourceName(String inputResourceName) throws IOException {
        Objects.requireNonNull(inputResourceName, "No input resource name provided");
        try {
            Path filePath = Paths.get(inputResourceName, new String[0]);
            this.inputResource = new FileInputResource(filePath);
        }
        catch (Exception e) {
            this.inputResource = new ClasspathInputResource(inputResourceName);
        }
    }

    public void setOutputEncoding(Charset outputCharset) {
        this.outputEncodingCharset = outputCharset == null ? StandardCharsets.UTF_8 : outputCharset;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncodingCharset = Utility.isBlank(outputEncoding) ? StandardCharsets.UTF_8 : Charset.forName(outputEncoding);
    }

    public void setOutputFile(Path outputFile) {
        Objects.requireNonNull(outputFile, "No output file provided");
        this.outputResource = new FileOutputResource(outputFile);
    }

    public void setOutputFormatValue(String outputFormatValue) {
        this.outputFormatValue = Objects.requireNonNull(outputFormatValue, "Cannot use null value in a setter");
    }

    public void setWriter(Writer writer) {
        Objects.requireNonNull(writer, "No output writer provided");
        this.outputResource = new WriterOutputResource(writer);
    }

    public String toString() {
        return ObjectToString.toString(this);
    }

    private void obtainInputResource() {
        if (this.inputResource == null) {
            try {
                this.setInputResourceName(this.outputFormatValue);
            }
            catch (IOException e) {
                this.inputResource = null;
            }
        }
    }

    private void obtainOutputResource() {
        if (this.outputResource == null) {
            this.outputResource = new ConsoleOutputResource();
        }
    }
}

