/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.operation.DataJsonFormatter;
import schemacrawler.tools.text.operation.DataTextFormatter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.operation.OperationOptionsBuilder;
import schemacrawler.tools.traversal.DataTraversalHandler;
import schemacrawler.utility.Identifiers;
import schemacrawler.utility.NamedObjectSort;
import schemacrawler.utility.Query;
import schemacrawler.utility.QueryUtility;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class OperationExecutable
extends BaseStagedExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(OperationExecutable.class.getName());
    private OperationOptions operationOptions;

    public OperationExecutable(String command) {
        super(command);
    }

    @Override
    public void executeOn(Catalog catalog, Connection connection) throws Exception {
        this.loadOperationOptions();
        if (!this.isOutputFormatSupported()) {
            LOGGER.log(Level.INFO, new StringFormat("Output format <%s> not supported for command <%s>", this.outputOptions.getOutputFormatValue(), this.getCommand()));
            return;
        }
        DataTraversalHandler handler = this.getDataTraversalHandler();
        Query query = this.getQuery();
        try (Statement statement = DatabaseUtility.createStatement(connection);){
            handler.begin();
            handler.handleInfoStart();
            handler.handle(catalog.getSchemaCrawlerInfo());
            handler.handle(catalog.getDatabaseInfo());
            handler.handle(catalog.getJdbcDriverInfo());
            handler.handleInfoEnd();
            if (query.isQueryOver()) {
                String identifierQuoteString = this.databaseSpecificOptions.getIdentifierQuoteString();
                Identifiers identifiers = Identifiers.identifiers().withIdentifierQuoteString(identifierQuoteString).build();
                for (Table table : this.getSortedTables(catalog)) {
                    boolean isAlphabeticalSortForTableColumns = this.operationOptions.isAlphabeticalSortForTableColumns();
                    ResultSet results = QueryUtility.executeAgainstTable(query, statement, table, isAlphabeticalSortForTableColumns, identifiers);
                    Throwable throwable = null;
                    try {
                        handler.handleData(table, results);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (results == null) continue;
                        if (throwable != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        results.close();
                    }
                }
            } else {
                String sql = query.getQuery();
                try (ResultSet results = DatabaseUtility.executeSql(statement, sql, true);){
                    handler.handleData(query, results);
                }
            }
            handler.end();
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException(String.format("Unknown command <%s>", this.getCommand()), e);
        }
    }

    public final OperationOptions getOperationOptions() {
        this.loadOperationOptions();
        return this.operationOptions;
    }

    public boolean isOutputFormatSupported() {
        String outputFormatValue = this.outputOptions.getOutputFormatValue();
        boolean isOutputFormatSupported = TextOutputFormat.isSupportedFormat(outputFormatValue);
        return isOutputFormatSupported;
    }

    public final void setOperationOptions(OperationOptions operationOptions) {
        this.operationOptions = operationOptions;
    }

    private DataTraversalHandler getDataTraversalHandler() throws SchemaCrawlerException {
        Operation operation = this.getOperation();
        OperationOptions operationOptions = this.getOperationOptions();
        TextOutputFormat outputFormat = TextOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        String identifierQuoteString = this.databaseSpecificOptions.getIdentifierQuoteString();
        BaseFormatter formatter = outputFormat == TextOutputFormat.json ? new DataJsonFormatter(operation, operationOptions, this.outputOptions, identifierQuoteString) : new DataTextFormatter(operation, operationOptions, this.outputOptions, identifierQuoteString);
        return formatter;
    }

    private Operation getOperation() {
        Operation operation = null;
        try {
            operation = Operation.valueOf(this.command);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            operation = null;
        }
        return operation;
    }

    private Query getQuery() {
        Query query;
        Operation operation = this.getOperation();
        if (operation == null) {
            String queryName = this.command;
            String queryString = this.additionalConfiguration != null ? this.additionalConfiguration.get(queryName) : null;
            query = new Query(queryName, queryString);
        } else {
            query = operation.getQuery();
        }
        return query;
    }

    private List<? extends Table> getSortedTables(Catalog catalog) {
        ArrayList<Table> tables = new ArrayList<Table>(catalog.getTables());
        Collections.sort(tables, NamedObjectSort.getNamedObjectSort(this.getOperationOptions().isAlphabeticalSortForTables()));
        return tables;
    }

    private void loadOperationOptions() {
        if (this.operationOptions == null) {
            this.operationOptions = (OperationOptions)new OperationOptionsBuilder().fromConfig(this.additionalConfiguration).toOptions();
        }
    }
}

