/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility.org.json;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import schemacrawler.tools.text.utility.org.json.JSONArray;
import schemacrawler.tools.text.utility.org.json.JSONException;

public class JSONObject {
    private static final Object NULL = new Null();
    private final Map map = new HashMap();

    private static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String hhhh = "000" + Integer.toHexString(c);
                        sb.append("\\u" + hhhh.substring(hhhh.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static void testValidity(Object o) throws JSONException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    static String valueToString(Object value) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONObject.quote(value.toString());
    }

    static Object wrap(Object object) {
        try {
            String objectPackageName;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            Package objectPackage = object.getClass().getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String valueToString(Object value, int indentFactor, int indent) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString(indentFactor, indent);
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString(indentFactor, indent);
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString(indentFactor, indent);
        }
        return JSONObject.quote(value.toString());
    }

    public JSONObject() {
    }

    private JSONObject(Object bean) {
        this();
        this.populateMap(bean);
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object object = this.opt(key);
        if (object == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).put(value);
        } else {
            this.put(key, new JSONArray().put(object).put(value));
        }
        return this;
    }

    private Iterator keys() {
        return this.map.keySet().iterator();
    }

    public int length() {
        return this.map.size();
    }

    private Object opt(String key) {
        return key == null ? null : this.map.get(key);
    }

    public JSONObject put(String key, boolean value) throws JSONException {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key, Collection value) throws JSONException {
        this.put(key, new JSONArray(value));
        return this;
    }

    public JSONObject put(String key, double value) throws JSONException {
        this.put(key, new Double(value));
        return this;
    }

    public JSONObject put(String key, int value) throws JSONException {
        this.put(key, new Integer(value));
        return this;
    }

    public JSONObject put(String key, long value) throws JSONException {
        this.put(key, new Long(value));
        return this;
    }

    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity(value);
            this.map.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    private Object remove(String key) {
        return this.map.remove(key);
    }

    public String toString() {
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JSONObject.quote(o.toString()));
                sb.append(':');
                sb.append(JSONObject.valueToString(this.map.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    Writer write(Writer writer) throws JSONException {
        try {
            boolean commanate = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (commanate) {
                    writer.write(44);
                }
                Object key = keys.next();
                writer.write(JSONObject.quote(key.toString()));
                writer.write(58);
                Object value = this.map.get(key);
                if (value instanceof JSONObject) {
                    ((JSONObject)value).write(writer);
                } else if (value instanceof JSONArray) {
                    ((JSONArray)value).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(value));
                }
                commanate = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    public void write(Writer writer, int indentFactor) throws JSONException {
        this.write(new PrintWriter(writer), indentFactor, 0);
    }

    private String toString(int indentFactor, int indent) throws JSONException {
        int length = this.length();
        if (length == 0) {
            return "{}";
        }
        Iterator keys = this.keys();
        int newindent = indent + indentFactor;
        StringBuffer sb = new StringBuffer("{");
        if (length == 1) {
            Object object = keys.next();
            sb.append(JSONObject.quote(object.toString()));
            sb.append(": ");
            sb.append(JSONObject.valueToString(this.map.get(object), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                Object object = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONObject.quote(object.toString()));
                sb.append(": ");
                sb.append(JSONObject.valueToString(this.map.get(object), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    private void write(PrintWriter writer, int indentFactor, int indent) throws JSONException {
        int length = this.length();
        if (length == 0) {
            writer.println("{}");
            return;
        }
        Iterator keys = this.keys();
        int newindent = indent + indentFactor;
        writer.print("{");
        if (length == 1) {
            Object object = keys.next();
            writer.print(JSONObject.quote(object.toString()));
            writer.print(": ");
            Object value = this.map.get(object);
            if (value instanceof JSONObject) {
                ((JSONObject)value).write(writer, indentFactor, newindent);
            } else if (value instanceof JSONArray) {
                ((JSONArray)value).write(writer, indentFactor, newindent);
            } else {
                writer.println(JSONObject.valueToString(value));
            }
        } else {
            int i;
            int keyCount = 0;
            while (keys.hasNext()) {
                Object object = keys.next();
                if (++keyCount > 1) {
                    writer.println(",");
                } else {
                    writer.println();
                }
                for (i = 0; i < newindent; ++i) {
                    writer.print(' ');
                }
                writer.print(JSONObject.quote(object.toString()));
                writer.print(": ");
                Object value = this.map.get(object);
                if (value instanceof JSONObject) {
                    ((JSONObject)value).write(writer, indentFactor, newindent);
                    continue;
                }
                if (value instanceof JSONArray) {
                    ((JSONArray)value).write(writer, indentFactor, newindent);
                    continue;
                }
                writer.print(JSONObject.valueToString(value));
            }
            if (keyCount > 1) {
                writer.println();
                for (i = 0; i < indent; ++i) {
                    writer.print(' ');
                }
            }
        }
        writer.print('}');
    }

    private void populateMap(Object bean) {
        Method[] methods;
        Class<?> klass = bean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        for (Method method : methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods()) {
            try {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = name.equals("getClass") || name.equals("getDeclaringClass") ? "" : name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                Object result = method.invoke(bean, (Object[])null);
                if (result == null) continue;
                this.map.put(key, JSONObject.wrap(result));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class Null {
        private Null() {
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }

        protected final Object clone() {
            return this;
        }
    }
}

