/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.sql.JDBCType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import schemacrawler.schema.JavaSqlType;
import sf.util.Utility;

public final class JavaSqlTypes
implements Iterable<JavaSqlType> {
    private final Map<Integer, JavaSqlType> javaSqlTypeMap = JavaSqlTypes.mapJavaSqlTypes();

    private static JavaSqlType.JavaSqlTypeGroup groupJavaSqlType(int type) {
        JavaSqlType.JavaSqlTypeGroup typeGroup;
        switch (type) {
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.object;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.binary;
                break;
            }
            case -7: 
            case 16: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.bit;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.character;
                break;
            }
            case -8: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.id;
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.integer;
                break;
            }
            case 2004: 
            case 2005: 
            case 2011: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.large_object;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.real;
                break;
            }
            case 2006: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.reference;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.temporal;
                break;
            }
            case 70: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.url;
                break;
            }
            case 2009: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.xml;
                break;
            }
            default: {
                typeGroup = JavaSqlType.JavaSqlTypeGroup.unknown;
            }
        }
        return typeGroup;
    }

    private static Map<Integer, JavaSqlType> mapJavaSqlTypes() {
        HashMap<Integer, JavaSqlType> javaSqlTypes = new HashMap<Integer, JavaSqlType>();
        for (JDBCType sqlType : JDBCType.values()) {
            Integer sqlTypeInt = sqlType.getVendorTypeNumber();
            JavaSqlType.JavaSqlTypeGroup sqlTypeGroup = JavaSqlTypes.groupJavaSqlType(sqlTypeInt);
            JavaSqlType javaSqlType = new JavaSqlType(sqlType, sqlTypeGroup);
            javaSqlTypes.put(sqlTypeInt, javaSqlType);
        }
        return javaSqlTypes;
    }

    public JavaSqlType getFromJavaSqlTypeName(String typeName) {
        JavaSqlType sqlDataType = JavaSqlType.UNKNOWN;
        if (Utility.isBlank(typeName)) {
            return sqlDataType;
        }
        for (JavaSqlType javaSqlType : this.javaSqlTypeMap.values()) {
            if (!typeName.equals(javaSqlType.getJavaSqlTypeName())) continue;
            sqlDataType = javaSqlType;
            break;
        }
        return sqlDataType;
    }

    @Override
    public Iterator<JavaSqlType> iterator() {
        return this.javaSqlTypeMap.values().iterator();
    }

    public int size() {
        return this.javaSqlTypeMap.size();
    }

    public String toString() {
        return this.javaSqlTypeMap.toString();
    }

    public JavaSqlType valueOf(int key) {
        if (this.javaSqlTypeMap.containsKey(key)) {
            return this.javaSqlTypeMap.get(key);
        }
        return JavaSqlType.UNKNOWN;
    }
}

