/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class TypeMap
implements Map<String, Class<?>> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TypeMap.class.getName());
    private final Map<String, Class<?>> sqlTypeMap;

    private static Map<String, Class<?>> createDefaultTypeMap() {
        HashMap sqlTypeMap = new HashMap();
        sqlTypeMap.put("ARRAY", Array.class);
        sqlTypeMap.put("BIGINT", Long.class);
        sqlTypeMap.put("BINARY", byte[].class);
        sqlTypeMap.put("BIT", Boolean.class);
        sqlTypeMap.put("BLOB", Blob.class);
        sqlTypeMap.put("BOOLEAN", Boolean.class);
        sqlTypeMap.put("CHAR", String.class);
        sqlTypeMap.put("CLOB", Clob.class);
        sqlTypeMap.put("DATALINK", URL.class);
        sqlTypeMap.put("DATE", Date.class);
        sqlTypeMap.put("DECIMAL", BigDecimal.class);
        sqlTypeMap.put("DISTINCT", Object.class);
        sqlTypeMap.put("DOUBLE", Double.class);
        sqlTypeMap.put("FLOAT", Double.class);
        sqlTypeMap.put("INTEGER", Integer.class);
        sqlTypeMap.put("JAVA_OBJECT", Object.class);
        sqlTypeMap.put("LONGNVARCHAR", String.class);
        sqlTypeMap.put("LONGVARBINARY", byte[].class);
        sqlTypeMap.put("LONGVARCHAR", String.class);
        sqlTypeMap.put("NCHAR", String.class);
        sqlTypeMap.put("NCLOB", NClob.class);
        sqlTypeMap.put("NULL", Void.class);
        sqlTypeMap.put("NUMERIC", BigDecimal.class);
        sqlTypeMap.put("NVARCHAR", String.class);
        sqlTypeMap.put("OTHER", Object.class);
        sqlTypeMap.put("REAL", Float.class);
        sqlTypeMap.put("REF", Ref.class);
        sqlTypeMap.put("ROWID", RowId.class);
        sqlTypeMap.put("SMALLINT", Integer.class);
        sqlTypeMap.put("SQLXML", SQLXML.class);
        sqlTypeMap.put("STRUCT", Struct.class);
        sqlTypeMap.put("TIME", Time.class);
        sqlTypeMap.put("TIMESTAMP", Timestamp.class);
        sqlTypeMap.put("TINYINT", Integer.class);
        sqlTypeMap.put("VARBINARY", byte[].class);
        sqlTypeMap.put("VARCHAR", String.class);
        return sqlTypeMap;
    }

    public TypeMap() {
        this.sqlTypeMap = TypeMap.createDefaultTypeMap();
    }

    public TypeMap(Connection connection) {
        this();
        if (connection != null) {
            try {
                Map<String, Class<?>> typeMap = connection.getTypeMap();
                if (typeMap != null && !typeMap.isEmpty()) {
                    this.sqlTypeMap.putAll(typeMap);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not obtain data type map from connection", (Throwable)e);
            }
        }
    }

    public TypeMap(Map<String, Class<?>> sqlTypeMap) {
        this.sqlTypeMap = sqlTypeMap == null ? new HashMap() : new HashMap(sqlTypeMap);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sqlTypeMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sqlTypeMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Class<?>>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        return this.sqlTypeMap.equals(o);
    }

    @Override
    public Class<?> get(Object key) {
        if (this.containsKey(key)) {
            return this.sqlTypeMap.get(key);
        }
        return Object.class;
    }

    public Class<?> get(String typeName, String className) {
        if (Utility.isBlank(className)) {
            return this.sqlTypeMap.get(typeName);
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.WARNING, new StringFormat("Could not obtain class mapping for data type <%s>", typeName), (Throwable)e);
            return null;
        }
    }

    @Override
    public int hashCode() {
        return this.sqlTypeMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.sqlTypeMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.sqlTypeMap.keySet());
    }

    @Override
    public Class<?> put(String key, Class<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Class<?>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.sqlTypeMap.size();
    }

    public String toString() {
        return this.sqlTypeMap.toString();
    }

    @Override
    public Collection<Class<?>> values() {
        return new HashSet(this.sqlTypeMap.values());
    }
}

