/*
 * Decompiled with CFR 0.152.
 */
package sf.util.graph;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import sf.util.graph.DirectedEdge;
import sf.util.graph.DirectedGraph;
import sf.util.graph.Vertex;

public class SimpleCycleDetector<T extends Comparable<? super T>> {
    private static final String ATTRIBUTE_TRAVERSAL_STATE = "traversalstate";
    private final DirectedGraph<T> graph;

    public SimpleCycleDetector(DirectedGraph<T> graph) {
        this.graph = Objects.requireNonNull(graph, "No graph provided");
    }

    public boolean containsCycle() {
        Collection<Vertex<T>> vertices = this.clearTraversalStates();
        for (Vertex<T> vertex : vertices) {
            if (vertex.getAttribute(ATTRIBUTE_TRAVERSAL_STATE) != TraversalState.notStarted || !this.visitForCyles(vertex)) continue;
            return true;
        }
        return false;
    }

    private Collection<Vertex<T>> clearTraversalStates() {
        Set<Vertex<T>> vertices = this.graph.vertexSet();
        for (Vertex vertex : vertices) {
            vertex.putAttribute(ATTRIBUTE_TRAVERSAL_STATE, (Object)TraversalState.notStarted);
        }
        return vertices;
    }

    private boolean visitForCyles(Vertex<T> vertex) {
        vertex.putAttribute(ATTRIBUTE_TRAVERSAL_STATE, (Object)TraversalState.inProgress);
        for (DirectedEdge<T> edge : this.graph.edgeSet()) {
            if (!edge.isFrom(vertex)) continue;
            Vertex<T> to = edge.getTo();
            if (to.getAttribute(ATTRIBUTE_TRAVERSAL_STATE) == TraversalState.inProgress) {
                to.putAttribute(ATTRIBUTE_TRAVERSAL_STATE, (Object)TraversalState.marked);
                return true;
            }
            if (to.getAttribute(ATTRIBUTE_TRAVERSAL_STATE) != TraversalState.notStarted || !this.visitForCyles(to)) continue;
            return true;
        }
        vertex.putAttribute(ATTRIBUTE_TRAVERSAL_STATE, (Object)TraversalState.complete);
        return false;
    }

    static enum TraversalState {
        notStarted("white"),
        inProgress("lightgray"),
        marked("red"),
        complete("gray");

        private final String color;

        private TraversalState(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }
    }
}

