/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.commandlineparser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import schemacrawler.Version;
import schemacrawler.schemacrawler.Config;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;
import us.fatehi.commandlineparser.CommandLineArgumentsParser;

public final class CommandLineUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(CommandLineUtility.class.getName());

    public static void applyApplicationLogLevel(Level applicationLogLevel) {
        Utility.applyApplicationLogLevel(applicationLogLevel);
    }

    public static void logFullStackTrace(Level level, Throwable t) {
        if (level == null || !LOGGER.isLoggable(level)) {
            return;
        }
        if (t == null) {
            return;
        }
        LOGGER.log(level, t.getMessage(), t);
    }

    public static void logSafeArguments(String[] args) {
        if (!LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        LOGGER.log(Level.INFO, new StringFormat("%s, v%s", Version.getProductName(), Version.getVersion()));
        if (args == null) {
            return;
        }
        ArrayList<String> argsList = new ArrayList<String>();
        Iterator<String> iterator = Arrays.asList(args).iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg == null) continue;
            if (arg.startsWith("-password=")) {
                argsList.add("-password=*****");
                continue;
            }
            if (arg.startsWith("-password")) {
                argsList.add("-password");
                if (!iterator.hasNext()) continue;
                iterator.next();
                argsList.add("*****");
                continue;
            }
            argsList.add(arg);
        }
        LOGGER.log(Level.INFO, new StringFormat("Command line: %n%s", Utility.join(argsList, System.lineSeparator())));
    }

    public static void logSystemProperties() {
        if (!LOGGER.isLoggable(Level.CONFIG)) {
            return;
        }
        TreeMap<String, String> systemProperties = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> propertyValue : System.getProperties().entrySet()) {
            String name = (String)propertyValue.getKey();
            if (!name.startsWith("java.") && !name.startsWith("os.") || name.endsWith(".path")) continue;
            systemProperties.put(name, (String)propertyValue.getValue());
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, new StringFormat("System properties: %n%s", Utility.join(systemProperties, System.lineSeparator())));
            LOGGER.log(Level.CONFIG, new StringFormat("Classpath: %n%s", Utility.join(System.getProperty("java.class.path").split(File.pathSeparator), System.lineSeparator())));
        }
    }

    public static Config parseArgs(String[] args) {
        CommandLineArgumentsParser argsParser = new CommandLineArgumentsParser(args);
        argsParser.parse();
        Config optionsMap = argsParser.getOptionsMap();
        return optionsMap;
    }

    private CommandLineUtility() {
    }
}

