/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.TablePartial;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.Query;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class ForeignKeyRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ForeignKeyRetriever.class.getName());

    ForeignKeyRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveForeignKeyDefinitions(NamedObjectList<MutableTable> allTables) {
        Objects.requireNonNull(allTables, "No tables provided");
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        Connection connection = this.getDatabaseConnection();
        if (!informationSchemaViews.hasExtForeignKeysSql()) {
            LOGGER.log(Level.FINE, "Extended foreign keys SQL statement was not provided");
            return;
        }
        NamedObjectList<MutableForeignKey> allFks = new NamedObjectList<MutableForeignKey>();
        for (MutableTable table : allTables) {
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                allFks.add((MutableForeignKey)foreignKey);
            }
        }
        Query extForeignKeysSql = informationSchemaViews.getExtForeignKeysSql();
        try {
            Statement statement = connection.createStatement();
            Object object = null;
            try (MetadataResultSet results = new MetadataResultSet(extForeignKeysSql, statement, this.getSchemaInclusionRule());){
                while (results.next()) {
                    String fkName = results.getString("FOREIGN_KEY_NAME");
                    LOGGER.log(Level.FINER, new StringFormat("Retrieving foreign key definition <%s>", fkName));
                    String definition = results.getString("FOREIGN_KEY_DEFINITION");
                    Optional optionalFk = allFks.lookup(Arrays.asList(fkName, fkName));
                    if (optionalFk.isPresent()) {
                        MutableForeignKey fkConstraint = (MutableForeignKey)optionalFk.get();
                        fkConstraint.appendDefinition(definition);
                        fkConstraint.addAttributes(results.getAttributes());
                        continue;
                    }
                    LOGGER.log(Level.FINER, new StringFormat("Could not find foreign key <%s>", fkName));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (object != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraints", (Throwable)e);
        }
    }

    void retrieveForeignKeys(NamedObjectList<MutableTable> allTables) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        MetadataRetrievalStrategy fkRetrievalStrategy = this.getRetrieverConnection().getForeignKeyRetrievalStrategy();
        switch (fkRetrievalStrategy) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving foreign keys, using fast data dictionary retrieval");
                this.retrieveForeignKeysFromDataDictionary();
                break;
            }
            case metadata_all: {
                LOGGER.log(Level.INFO, "Retrieving foreign keys, using fast meta-data retrieval");
                this.retrieveForeignKeysFromMetadataForAllTables();
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving foreign keys");
                this.retrieveForeignKeysFromMetadata(allTables);
                break;
            }
        }
    }

    private void createForeignKeys(MetadataResultSet results, NamedObjectList<MutableForeignKey> foreignKeys) throws SQLException {
        while (results.next()) {
            MutableForeignKey foreignKey;
            String foreignKeyName = results.getString("FK_NAME");
            LOGGER.log(Level.FINE, new StringFormat("Retrieving foreign key: %s", foreignKeyName));
            String pkTableCatalogName = this.normalizeCatalogName(results.getString("PKTABLE_CAT"));
            String pkTableSchemaName = this.normalizeSchemaName(results.getString("PKTABLE_SCHEM"));
            String pkTableName = results.getString("PKTABLE_NAME");
            String pkColumnName = results.getString("PKCOLUMN_NAME");
            String fkTableCatalogName = this.normalizeCatalogName(results.getString("FKTABLE_CAT"));
            String fkTableSchemaName = this.normalizeSchemaName(results.getString("FKTABLE_SCHEM"));
            String fkTableName = results.getString("FKTABLE_NAME");
            String fkColumnName = results.getString("FKCOLUMN_NAME");
            int keySequence = results.getInt("KEY_SEQ", 0);
            ForeignKeyUpdateRule updateRule = results.getEnumFromId("UPDATE_RULE", ForeignKeyUpdateRule.unknown);
            ForeignKeyUpdateRule deleteRule = results.getEnumFromId("DELETE_RULE", ForeignKeyUpdateRule.unknown);
            ForeignKeyDeferrability deferrability = results.getEnumFromId("DEFERRABILITY", ForeignKeyDeferrability.unknown);
            Column pkColumn = this.lookupOrCreateColumn(pkTableCatalogName, pkTableSchemaName, pkTableName, pkColumnName);
            Column fkColumn = this.lookupOrCreateColumn(fkTableCatalogName, fkTableSchemaName, fkTableName, fkColumnName);
            boolean isPkColumnPartial = pkColumn instanceof ColumnPartial;
            boolean isFkColumnPartial = fkColumn instanceof ColumnPartial;
            if (pkColumn == null || fkColumn == null || isFkColumnPartial && isPkColumnPartial) continue;
            String specificName = Utility.isBlank(foreignKeyName) ? MetaDataUtility.constructForeignKeyName(pkColumn, fkColumn) : foreignKeyName;
            Optional<MutableForeignKey> foreignKeyOptional = foreignKeys.lookup(Arrays.asList(foreignKeyName, specificName));
            if (foreignKeyOptional.isPresent()) {
                foreignKey = foreignKeyOptional.get();
            } else {
                foreignKey = new MutableForeignKey(foreignKeyName);
                foreignKey.setSpecificName(specificName);
                foreignKeys.add(foreignKey);
            }
            foreignKey.addColumnReference(keySequence, pkColumn, fkColumn);
            foreignKey.setUpdateRule(updateRule);
            foreignKey.setDeleteRule(deleteRule);
            foreignKey.setDeferrability(deferrability);
            foreignKey.addAttributes(results.getAttributes());
            if (fkColumn instanceof MutableColumn) {
                ((MutableColumn)fkColumn).setReferencedColumn(pkColumn);
                ((MutableTable)fkColumn.getParent()).addForeignKey(foreignKey);
            } else if (isFkColumnPartial) {
                ((ColumnPartial)fkColumn).setReferencedColumn(pkColumn);
                ((TablePartial)fkColumn.getParent()).addForeignKey(foreignKey);
            }
            if (pkColumn instanceof MutableColumn) {
                ((MutableTable)pkColumn.getParent()).addForeignKey(foreignKey);
                continue;
            }
            if (!isPkColumnPartial) continue;
            ((TablePartial)pkColumn.getParent()).addForeignKey(foreignKey);
        }
    }

    private Column lookupOrCreateColumn(String catalogName, String schemaName, String tableName, String columnName) {
        Table table;
        Optional<? extends Column> columnOptional;
        Column column = null;
        Optional<MutableTable> tableOptional = this.catalog.lookupTable(Arrays.asList(catalogName, schemaName, tableName));
        if (tableOptional.isPresent() && (columnOptional = (table = (Table)tableOptional.get()).lookupColumn(columnName)).isPresent()) {
            column = columnOptional.get();
        }
        if (column == null) {
            SchemaReference schema = new SchemaReference(catalogName, schemaName);
            TablePartial table2 = new TablePartial(schema, tableName);
            column = new ColumnPartial(table2, columnName);
            table2.addColumn(column);
            LOGGER.log(Level.FINER, new StringFormat("Creating column reference for a column that is referenced by a foreign key <%s>", column.getFullName()));
        }
        return column;
    }

    private void retrieveForeignKeysFromDataDictionary() throws SchemaCrawlerSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasForeignKeysSql()) {
            LOGGER.log(Level.FINE, "Extended foreign keys SQL statement was not provided");
            return;
        }
        NamedObjectList<MutableForeignKey> foreignKeys = new NamedObjectList<MutableForeignKey>();
        Query fkSql = informationSchemaViews.getForeignKeysSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(fkSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveForeignKeysUsingSql");
            this.createForeignKeys(results, foreignKeys);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve foreign keys from SQL:\n" + fkSql, e);
        }
    }

    private void retrieveForeignKeysFromMetadata(NamedObjectList<MutableTable> allTables) throws SchemaCrawlerSQLException {
        NamedObjectList<MutableForeignKey> foreignKeys = new NamedObjectList<MutableForeignKey>();
        for (MutableTable table : allTables) {
            Throwable throwable;
            MetadataResultSet results;
            if (table instanceof View) continue;
            DatabaseMetaData metaData = this.getMetaData();
            try {
                results = new MetadataResultSet(metaData.getImportedKeys(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName()));
                throwable = null;
                try {
                    this.createForeignKeys(results, foreignKeys);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results != null) {
                        if (throwable != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            results.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new SchemaCrawlerSQLException("Could not retrieve foreign keys for table " + table, e);
            }
            try {
                results = new MetadataResultSet(metaData.getExportedKeys(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName()));
                throwable = null;
                try {
                    this.createForeignKeys(results, foreignKeys);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    results.close();
                }
            }
            catch (SQLException e) {
                throw new SchemaCrawlerSQLException("Could not retrieve foreign keys for table " + table, e);
            }
        }
    }

    private void retrieveForeignKeysFromMetadataForAllTables() throws SQLException {
        NamedObjectList<MutableForeignKey> foreignKeys = new NamedObjectList<MutableForeignKey>();
        DatabaseMetaData metaData = this.getMetaData();
        try (MetadataResultSet results = new MetadataResultSet(metaData.getImportedKeys(null, null, "%"));){
            this.createForeignKeys(results, foreignKeys);
        }
        results = new MetadataResultSet(metaData.getExportedKeys(null, null, "%"));
        var4_4 = null;
        try {
            this.createForeignKeys(results, foreignKeys);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (results != null) {
                if (var4_4 != null) {
                    try {
                        results.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    results.close();
                }
            }
        }
    }
}

