/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import schemacrawler.crawl.BaseProductVersion;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.OperatingSystemInfo;
import schemacrawler.schema.ProductVersion;
import schemacrawler.schema.SchemaCrawlerInfo;

final class ImmutableCrawlInfo
implements CrawlInfo {
    private static final long serialVersionUID = 5982990326485881993L;
    private final ProductVersion schemaCrawlerInfo;
    private final ProductVersion jdbcDriverInfo;
    private final ProductVersion databaseInfo;
    private final ProductVersion osInfo;
    private final String title;
    private final LocalDateTime crawlTimestamp;

    ImmutableCrawlInfo(SchemaCrawlerInfo schemaCrawlerInfo, JdbcDriverInfo jdbcDriverInfo, DatabaseInfo databaseInfo, OperatingSystemInfo osInfo, String title) {
        Objects.requireNonNull(schemaCrawlerInfo, "No SchemaCrawler information provided");
        this.schemaCrawlerInfo = new BaseProductVersion(schemaCrawlerInfo.getProductName(), schemaCrawlerInfo.getProductVersion());
        Objects.requireNonNull(jdbcDriverInfo, "No JDBC driver information provided");
        this.jdbcDriverInfo = new BaseProductVersion(jdbcDriverInfo.getProductName(), jdbcDriverInfo.getProductVersion());
        Objects.requireNonNull(databaseInfo, "No database information provided");
        this.databaseInfo = new BaseProductVersion(databaseInfo.getProductName(), databaseInfo.getProductVersion());
        Objects.requireNonNull(osInfo, "No database information provided");
        this.osInfo = new BaseProductVersion(osInfo.getProductName(), osInfo.getProductVersion());
        this.title = title;
        this.crawlTimestamp = LocalDateTime.now();
    }

    @Override
    public LocalDateTime getCrawlTimestamp() {
        return this.crawlTimestamp;
    }

    @Override
    public String getDatabaseInfo() {
        return this.databaseInfo.toString();
    }

    @Override
    public String getJdbcDriverInfo() {
        return this.jdbcDriverInfo.toString();
    }

    public String getOperatingSystemInfo() {
        return this.osInfo.toString();
    }

    @Override
    public String getSchemaCrawlerInfo() {
        return this.schemaCrawlerInfo.toString();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- generated by: ").append(this.schemaCrawlerInfo).append(System.lineSeparator());
        info.append("-- generated on: ").append(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(this.getCrawlTimestamp())).append(System.lineSeparator());
        info.append("-- database: ").append(this.databaseInfo).append(System.lineSeparator());
        info.append("-- driver: ").append(this.jdbcDriverInfo).append(System.lineSeparator());
        info.append("-- operating system: ").append(this.osInfo).append(System.lineSeparator());
        return info.toString();
    }
}

