/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.Optional;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.TableReference;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexColumnSortSequence;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Table;

final class MutableIndexColumn
extends AbstractDependantObject<Table>
implements IndexColumn {
    private static final long serialVersionUID = -6923211341742623556L;
    private final Column column;
    private final Index index;
    private int indexOrdinalPosition;
    private IndexColumnSortSequence sortSequence;
    private final StringBuilder definition;

    MutableIndexColumn(Index index, Column column) {
        super(new TableReference((Table)column.getParent()), column.getName());
        this.index = index;
        this.column = column;
        this.definition = new StringBuilder();
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        int comparison = 0;
        if (obj instanceof MutableIndexColumn) {
            MutableIndexColumn other = (MutableIndexColumn)obj;
            comparison = this.indexOrdinalPosition - other.indexOrdinalPosition;
        }
        if (comparison == 0) {
            comparison = super.compareTo(obj);
        }
        return comparison;
    }

    @Override
    public ColumnDataType getColumnDataType() {
        return this.column.getColumnDataType();
    }

    @Override
    public int getDecimalDigits() {
        return this.column.getDecimalDigits();
    }

    @Override
    public String getDefaultValue() {
        return this.column.getDefaultValue();
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public int getIndexOrdinalPosition() {
        return this.indexOrdinalPosition;
    }

    @Override
    public int getOrdinalPosition() {
        return this.column.getOrdinalPosition();
    }

    @Override
    public Collection<Privilege<Column>> getPrivileges() {
        return this.column.getPrivileges();
    }

    @Override
    public Column getReferencedColumn() {
        return this.column.getReferencedColumn();
    }

    @Override
    public int getSize() {
        return this.column.getSize();
    }

    @Override
    public IndexColumnSortSequence getSortSequence() {
        return this.sortSequence;
    }

    @Override
    public ColumnDataType getType() {
        return (ColumnDataType)this.column.getType();
    }

    @Override
    public String getWidth() {
        return this.column.getWidth();
    }

    @Override
    public boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public boolean isAutoIncremented() {
        return this.column.isAutoIncremented();
    }

    @Override
    public boolean isGenerated() {
        return this.column.isGenerated();
    }

    @Override
    public boolean isHidden() {
        return this.column.isHidden();
    }

    @Override
    public boolean isNullable() {
        return this.column.isNullable();
    }

    @Override
    public boolean isPartOfForeignKey() {
        return this.column.isPartOfForeignKey();
    }

    @Override
    public boolean isPartOfIndex() {
        return this.column.isPartOfIndex();
    }

    @Override
    public boolean isPartOfPrimaryKey() {
        return this.column.isPartOfPrimaryKey();
    }

    @Override
    public boolean isPartOfUniqueIndex() {
        return this.column.isPartOfUniqueIndex();
    }

    @Override
    public Optional<? extends Privilege<Column>> lookupPrivilege(String name) {
        return this.column.lookupPrivilege(name);
    }

    void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    void setGenerated(boolean isGenerated) {
        if (this.column instanceof MutableColumn) {
            ((MutableColumn)this.column).setGenerated(isGenerated);
        }
    }

    void setIndexOrdinalPosition(int indexOrdinalPosition) {
        this.indexOrdinalPosition = indexOrdinalPosition;
    }

    void setSortSequence(IndexColumnSortSequence sortSequence) {
        this.sortSequence = sortSequence;
    }
}

