/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.Column;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.utility.Query;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class TableColumnRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableColumnRetriever.class.getName());

    TableColumnRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveColumns(NamedObjectList<MutableTable> allTables, InclusionRule columnInclusionRule) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        InclusionRuleFilter<Column> columnFilter = new InclusionRuleFilter<Column>(columnInclusionRule, true);
        if (columnFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving columns, since this was not requested");
            return;
        }
        Set<List<String>> hiddenColumns = this.retrieveHiddenColumns();
        MetadataRetrievalStrategy tableColumnRetrievalStrategy = this.getRetrieverConnection().getTableColumnRetrievalStrategy();
        switch (tableColumnRetrievalStrategy) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving table columns, using fast data dictionary retrieval");
                this.retrieveColumnsFromDataDictionary(allTables, columnFilter, hiddenColumns);
                break;
            }
            case metadata_all: {
                LOGGER.log(Level.INFO, "Retrieving table columns, using fast meta-data retrieval");
                this.retrieveColumnsFromMetadataForAllTables(allTables, columnFilter, hiddenColumns);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving table columns");
                this.retrieveColumnsFromMetadata(allTables, columnFilter, hiddenColumns);
                break;
            }
        }
    }

    private MutableColumn createTableColumn(MetadataResultSet results, NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter, Set<List<String>> hiddenColumns) {
        String defaultValue = results.getString("COLUMN_DEF");
        String columnCatalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
        String tableName = results.getString("TABLE_NAME");
        String columnName = results.getString("COLUMN_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving column <%s.%s.%s.%s>", columnCatalogName, schemaName, tableName, columnName));
        Optional<MutableTable> optionalTable = allTables.lookup(Arrays.asList(columnCatalogName, schemaName, tableName));
        if (!optionalTable.isPresent()) {
            return null;
        }
        MutableTable table = optionalTable.get();
        MutableColumn column = this.lookupOrCreateColumn(table, columnName);
        if (columnFilter.test(column) && this.belongsToSchema(table, columnCatalogName, schemaName)) {
            String[] split;
            column = this.lookupOrCreateColumn(table, columnName);
            int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
            int dataType = results.getInt("DATA_TYPE", 0);
            String typeName = results.getString("TYPE_NAME");
            int size = results.getInt("COLUMN_SIZE", 0);
            int decimalDigits = results.getInt("DECIMAL_DIGITS", 0);
            boolean isNullable = results.getInt("NULLABLE", 2) == 1;
            boolean isAutoIncremented = results.getBoolean("IS_AUTOINCREMENT");
            boolean isGenerated = results.getBoolean("IS_GENERATEDCOLUMN");
            String remarks = results.getString("REMARKS");
            List<String> lookupKey = Arrays.asList(columnCatalogName, schemaName, tableName, columnName);
            boolean isHidden = hiddenColumns.contains(lookupKey);
            String columnDataTypeName = null;
            if (!Utility.isBlank(typeName) && (split = typeName.split("\\.")).length > 0) {
                columnDataTypeName = split[split.length - 1];
            }
            if (Utility.isBlank(columnDataTypeName)) {
                columnDataTypeName = typeName;
            }
            column.setOrdinalPosition(ordinalPosition);
            column.setColumnDataType(this.lookupOrCreateColumnDataType(table.getSchema(), dataType, columnDataTypeName));
            column.setSize(size);
            column.setDecimalDigits(decimalDigits);
            column.setNullable(isNullable);
            column.setAutoIncremented(isAutoIncremented);
            column.setGenerated(isGenerated);
            column.setRemarks(remarks);
            if (defaultValue != null) {
                column.setDefaultValue(defaultValue);
            }
            column.addAttributes(results.getAttributes());
            LOGGER.log(Level.FINER, new StringFormat("Adding %scolumn to table <%s>", isHidden ? "hidden " : "", column.getFullName()));
            if (isHidden) {
                column.setHidden(true);
                table.addHiddenColumn(column);
            } else {
                table.addColumn(column);
            }
        }
        return column;
    }

    private MutableColumn lookupOrCreateColumn(MutableTable table, String columnName) {
        Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
        MutableColumn column = columnOptional.isPresent() ? columnOptional.get() : new MutableColumn(table, columnName);
        return column;
    }

    private void retrieveColumnsFromDataDictionary(NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter, Set<List<String>> hiddenColumns) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasTableColumnsSql()) {
            throw new SchemaCrawlerSQLException("No table columns SQL provided", null);
        }
        Query tableColumnsSql = informationSchemaViews.getTableColumnsSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableColumnsSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveColumnsFromDataDictionary");
            while (results.next()) {
                this.createTableColumn(results, allTables, columnFilter, hiddenColumns);
            }
        }
    }

    private void retrieveColumnsFromMetadata(NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter, Set<List<String>> hiddenColumns) throws SchemaCrawlerSQLException {
        for (MutableTable table : allTables) {
            LOGGER.log(Level.FINE, "Retrieving columns for " + table);
            try {
                MetadataResultSet results = new MetadataResultSet(this.getMetaData().getColumns(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName(), null));
                Throwable throwable = null;
                try {
                    while (results.next()) {
                        this.createTableColumn(results, allTables, columnFilter, hiddenColumns);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
            catch (SQLException e) {
                throw new SchemaCrawlerSQLException(String.format("Could not retrieve columns for %s <%s>", table.getTableType(), table), e);
            }
        }
    }

    private void retrieveColumnsFromMetadataForAllTables(NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter, Set<List<String>> hiddenColumns) throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getColumns(null, null, "%", "%"));){
            while (results.next()) {
                this.createTableColumn(results, allTables, columnFilter, hiddenColumns);
            }
        }
    }

    private Set<List<String>> retrieveHiddenColumns() throws SQLException {
        HashSet<List<String>> hiddenColumns = new HashSet<List<String>>();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasExtHiddenTableColumnsSql()) {
            LOGGER.log(Level.INFO, "No hidden table columns SQL provided");
            return hiddenColumns;
        }
        Query hiddenColumnsSql = informationSchemaViews.getExtHiddenTableColumnsSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(hiddenColumnsSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveHiddenColumns");
            while (results.next()) {
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                String columnName = results.getString("COLUMN_NAME");
                LOGGER.log(Level.FINE, new StringFormat("Retrieving hidden column <%s.%s.%s.%s>", catalogName, schemaName, tableName, columnName));
                List<String> lookupKey = Arrays.asList(catalogName, schemaName, tableName, columnName);
                hiddenColumns.add(lookupKey);
            }
        }
        return hiddenColumns;
    }
}

