/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import schemacrawler.schemacrawler.ExcludeAll;
import schemacrawler.schemacrawler.IncludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.RegularExpressionExclusionRule;
import schemacrawler.schemacrawler.RegularExpressionInclusionRule;
import schemacrawler.schemacrawler.RegularExpressionRule;
import sf.util.ObjectToString;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class Config
implements Options,
Map<String, String> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(Config.class.getName());
    private final Map<String, String> config = new HashMap<String, String>();

    private static Map<String, String> propertiesMap(Properties properties) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (properties != null) {
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                propertiesMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return propertiesMap;
    }

    public Config() {
    }

    public Config(Map<String, String> config) {
        this();
        if (config != null) {
            this.putAll((Map<? extends String, ? extends String>)config);
        }
    }

    public Config(Properties properties) {
        this(Config.propertiesMap(properties));
    }

    @Override
    public void clear() {
        this.config.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.config.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.config.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.config.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.config.get(key);
    }

    public boolean getBooleanValue(String propertyName) {
        return this.getBooleanValue(propertyName, false);
    }

    public boolean getBooleanValue(String propertyName, boolean defaultValue) {
        return Boolean.parseBoolean(this.getStringValue(propertyName, Boolean.toString(defaultValue)));
    }

    public double getDoubleValue(String propertyName, double defaultValue) {
        try {
            return Double.parseDouble(this.getStringValue(propertyName, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, new StringFormat("Could not parse double value for property <%s>", propertyName), (Throwable)e);
            return defaultValue;
        }
    }

    public <E extends Enum<E>> E getEnumValue(String propertyName, E defaultValue) {
        Objects.requireNonNull(defaultValue, "No default value provided");
        String value = this.getStringValue(propertyName, defaultValue.name());
        return Utility.enumValue(value, defaultValue);
    }

    public InclusionRule getExclusionRule(String optionName) {
        String value = this.getStringValue(optionName, null);
        InclusionRule schemaInclusionRule = !Utility.isBlank(value) ? new RegularExpressionExclusionRule(value) : new IncludeAll();
        return schemaInclusionRule;
    }

    public InclusionRule getInclusionRule(String optionName) {
        String value = this.getStringValue(optionName, null);
        InclusionRule schemaInclusionRule = !Utility.isBlank(value) ? new RegularExpressionInclusionRule(value) : new ExcludeAll();
        return schemaInclusionRule;
    }

    public InclusionRule getInclusionRule(String includePatternProperty, String excludePatternProperty) {
        InclusionRule inclusionRule = this.getInclusionRuleOrNull(includePatternProperty, excludePatternProperty);
        if (inclusionRule == null) {
            return new IncludeAll();
        }
        return inclusionRule;
    }

    public InclusionRule getInclusionRuleDefaultExclude(String includePatternProperty, String excludePatternProperty) {
        return new RegularExpressionRule(this.getStringValue(includePatternProperty, ""), this.getStringValue(excludePatternProperty, ".*"));
    }

    public InclusionRule getInclusionRuleOrNull(String includePatternProperty, String excludePatternProperty) {
        String includePattern = this.getStringValue(includePatternProperty, null);
        String excludePattern = this.getStringValue(excludePatternProperty, null);
        if (Utility.isBlank(includePattern) && Utility.isBlank(excludePattern)) {
            return null;
        }
        return new RegularExpressionRule(includePattern, excludePattern);
    }

    public int getIntegerValue(String propertyName, int defaultValue) {
        try {
            return Integer.parseInt(this.getStringValue(propertyName, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, new StringFormat("Could not parse integer value for property <%s>", propertyName), (Throwable)e);
            return defaultValue;
        }
    }

    public long getLongValue(String propertyName, long defaultValue) {
        try {
            return Long.parseLong(this.getStringValue(propertyName, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, new StringFormat("Could not parse long value for property <%s>", propertyName), (Throwable)e);
            return defaultValue;
        }
    }

    public String getStringValue(String propertyName, String defaultValue) {
        String value = this.get(propertyName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public boolean hasValue(String propertyName) {
        return this.config.containsKey(propertyName);
    }

    @Override
    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.config.keySet();
    }

    @Override
    public String put(String key, String value) {
        return this.config.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.config.putAll(m);
    }

    @Override
    public String remove(Object key) {
        return this.config.remove(key);
    }

    public void setBooleanValue(String propertyName, boolean value) {
        this.put(propertyName, Boolean.toString(value));
    }

    public <E extends Enum<E>> void setEnumValue(String propertyName, E value) {
        if (value == null) {
            this.remove(propertyName);
        } else {
            this.put(propertyName, value.name());
        }
    }

    public void setStringValue(String propertyName, String value) {
        if (value == null) {
            this.remove(propertyName);
        } else {
            this.put(propertyName, value);
        }
    }

    @Override
    public int size() {
        return this.config.size();
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : this.config.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public String toString() {
        return ObjectToString.toString(this);
    }

    @Override
    public Collection<String> values() {
        return this.config.values();
    }
}

