/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import schemacrawler.schema.BaseForeignKey;
import schemacrawler.schema.NamedObject;
import schemacrawler.tools.analysis.associations.WeakAssociation;
import schemacrawler.utility.CompareUtility;

public class WeakAssociationForeignKey
implements BaseForeignKey<WeakAssociation> {
    private static final long serialVersionUID = -5164664131926303038L;
    private final String name;
    private final SortedSet<WeakAssociation> columnReferences = new TreeSet<WeakAssociation>();

    public WeakAssociationForeignKey(String name) {
        this.name = Objects.requireNonNull(name, "No name provided");
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        BaseForeignKey other = (BaseForeignKey)obj;
        List<WeakAssociation> thisColumnReferences = this.getColumnReferences();
        List otherColumnReferences = other.getColumnReferences();
        return CompareUtility.compareLists(thisColumnReferences, otherColumnReferences);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeakAssociationForeignKey other = (WeakAssociationForeignKey)obj;
        return !(this.columnReferences == null ? other.columnReferences != null : !this.columnReferences.equals(other.columnReferences));
    }

    @Override
    public List<WeakAssociation> getColumnReferences() {
        return new ArrayList<WeakAssociation>(this.columnReferences);
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnReferences == null ? 0 : this.columnReferences.hashCode());
        return result;
    }

    public boolean isValid() {
        for (WeakAssociation weakAssociation : this.columnReferences) {
            if (weakAssociation == null) {
                return false;
            }
            if (weakAssociation.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<WeakAssociation> iterator() {
        return this.columnReferences.iterator();
    }

    public String toString() {
        return this.columnReferences.toString();
    }

    @Override
    public List<String> toUniqueLookupKey() {
        return Arrays.asList(this.getName());
    }

    void add(WeakAssociation weakAssociation) {
        if (weakAssociation != null) {
            this.columnReferences.add(weakAssociation);
        }
    }
}

