/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.counts;

import java.util.Objects;
import java.util.function.Predicate;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.analysis.counts.CountsUtility;

class TableCountFilter
implements Predicate<Table> {
    private final boolean hideEmptyTables;

    public TableCountFilter(SchemaCrawlerOptions options) {
        this.hideEmptyTables = Objects.requireNonNull(options, "No SchemaCrawlerOptions provided").isHideEmptyTables();
    }

    @Override
    public boolean test(Table table) {
        long count;
        boolean hideTable = this.hideEmptyTables ? (count = CountsUtility.getRowCount(table)) == 0L : false;
        return !hideTable;
    }
}

