/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.util.ArrayList;
import java.util.Collection;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.executable.ExecutableCommandProvider;
import schemacrawler.tools.integration.embeddedgraph.EmbeddedGraphExecutable;
import schemacrawler.tools.integration.graph.GraphExecutable;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import sf.util.Utility;

public final class GraphExecutableCommandProvider
extends ExecutableCommandProvider {
    private static Collection<String> supportedCommands = GraphExecutableCommandProvider.supportedCommands();

    private static Collection<String> supportedCommands() {
        ArrayList<String> supportedCommands = new ArrayList<String>();
        for (SchemaTextDetailType schemaTextDetailType : SchemaTextDetailType.values()) {
            supportedCommands.add(schemaTextDetailType.name());
        }
        return supportedCommands;
    }

    public GraphExecutableCommandProvider() {
        super(supportedCommands, "");
    }

    @Override
    public Executable configureNewExecutable(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) throws SchemaCrawlerException {
        BaseStagedExecutable executable;
        boolean supportsCommand = this.supportsCommand(command, schemaCrawlerOptions, outputOptions);
        if (!supportsCommand) {
            throw new SchemaCrawlerException(String.format("Command <%s> not supported", command));
        }
        String outputFormatValue = outputOptions.getOutputFormatValue();
        boolean isGraph = GraphOutputFormat.isSupportedFormat(outputFormatValue);
        boolean isEmbeddedGraph = GraphOutputFormat.htmlx.getFormat().equalsIgnoreCase(outputFormatValue);
        if (isEmbeddedGraph) {
            executable = new EmbeddedGraphExecutable(command);
        } else if (isGraph) {
            executable = new GraphExecutable(command);
        } else {
            throw new SchemaCrawlerException(String.format("Command <%s> not supported", command));
        }
        if (schemaCrawlerOptions != null) {
            executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        }
        if (outputOptions != null) {
            executable.setOutputOptions(outputOptions);
        }
        return executable;
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return GraphExecutableCommandProvider.supportedCommands();
    }

    @Override
    public boolean supportsCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        if (Utility.isBlank(command) || outputOptions == null) {
            return false;
        }
        String outputFormatValue = outputOptions.getOutputFormatValue();
        return supportedCommands.contains(command) && (Utility.isBlank(outputFormatValue) || GraphOutputFormat.isSupportedFormat(outputFormatValue));
    }
}

