/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.nio.file.Path;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.graph.AbstractGraphProcessExecutor;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.integration.graph.GraphvizJavaExecutorUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

final class GraphJavaExecutor
extends AbstractGraphProcessExecutor {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphJavaExecutor.class.getName());

    GraphJavaExecutor(Path dotFile, Path outputFile, GraphOutputFormat graphOutputFormat) throws SchemaCrawlerException {
        super(dotFile, outputFile, graphOutputFormat);
    }

    @Override
    public Boolean call() {
        try {
            GraphvizJavaExecutorUtility.generateGraph(this.dotFile, this.outputFile, this.graphOutputFormat);
        }
        catch (SchemaCrawlerException e) {
            LOGGER.log(Level.INFO, String.format("Could not generate diagram from:%n%s", this.dotFile), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean canGenerate() {
        boolean supportsFormat;
        boolean hasClass;
        String className = "guru.nidi.graphviz.engine.Graphviz";
        try {
            Class.forName("guru.nidi.graphviz.engine.Graphviz");
            hasClass = true;
            supportsFormat = hasClass && GraphvizJavaExecutorUtility.canMap(this.graphOutputFormat);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, new StringFormat("Could not load <%s>", "guru.nidi.graphviz.engine.Graphviz"), (Throwable)e);
            hasClass = false;
            supportsFormat = false;
        }
        LOGGER.log(Level.INFO, new StringFormat("Checking if diagram can be generated -  can load <%s> = <%b>,  can generate format <%s> = <%b>", "guru.nidi.graphviz.engine.Graphviz", hasClass, this.graphOutputFormat.getDescription(), supportsFormat));
        return hasClass && supportsFormat;
    }
}

