/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizJdkEngine;
import guru.nidi.graphviz.engine.GraphvizV8Engine;
import java.io.FileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import sf.util.IOUtility;

public final class GraphvizJavaExecutorUtility {
    public static boolean canMap(GraphOutputFormat graphOutputFormat) {
        return GraphvizJavaExecutorUtility.map(graphOutputFormat) != null;
    }

    public static void generateGraph(Path dotFile, Path outputFile, GraphOutputFormat graphOutputFormat) throws SchemaCrawlerException {
        Objects.requireNonNull(dotFile, "No DOT file provided");
        Objects.requireNonNull(outputFile, "No graph output file provided");
        Objects.requireNonNull(graphOutputFormat, "No graph output format provided");
        try {
            String dotSource = IOUtility.readFully(new FileReader(dotFile.toFile()));
            dotSource = dotSource.replaceAll("\\R", " ");
            Graphviz.useEngine((GraphvizEngine)new GraphvizV8Engine(), (GraphvizEngine[])new GraphvizEngine[]{new GraphvizJdkEngine()});
            Format format = GraphvizJavaExecutorUtility.map(graphOutputFormat);
            Graphviz.fromString((String)dotSource).render(format).toFile(outputFile.toFile());
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Cannot generate graph from " + dotFile, e);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new IllegalArgumentException("<format> <DOT file> <output file>");
        }
        GraphOutputFormat graphOutputFormat = GraphOutputFormat.valueOf(args[0]);
        Path dotFile = Paths.get(args[1], new String[0]).normalize().toAbsolutePath();
        Path outputFile = Paths.get(args[2], new String[0]).normalize().toAbsolutePath();
        GraphvizJavaExecutorUtility.generateGraph(dotFile, outputFile, graphOutputFormat);
    }

    private static Format map(GraphOutputFormat graphOutputFormat) {
        Format format;
        if (graphOutputFormat == null) {
            return null;
        }
        switch (graphOutputFormat) {
            case svg: {
                format = Format.SVG;
                break;
            }
            case png: {
                format = Format.PNG;
                break;
            }
            case ps: {
                format = Format.PS;
                break;
            }
            case xdot: {
                format = Format.XDOT;
                break;
            }
            case plain: {
                format = Format.PLAIN;
                break;
            }
            default: {
                format = null;
            }
        }
        return format;
    }

    private GraphvizJavaExecutorUtility() {
    }
}

