/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.scripting;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.integration.scripting.ScriptExecutable;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.iosource.StringInputResource;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;

public class ScriptCommandProvider
implements CommandProvider {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ScriptCommandProvider.class.getName());

    @Override
    public Executable configureNewExecutable(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        ScriptExecutable executable = new ScriptExecutable();
        executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        executable.setOutputOptions(outputOptions);
        return executable;
    }

    @Override
    public InputResource getHelp() {
        String helpResource = "/help/ScriptExecutable.txt";
        try {
            return new ClasspathInputResource("/help/ScriptExecutable.txt");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Could not load help resource <%s>", "/help/ScriptExecutable.txt"), (Throwable)e);
            return new StringInputResource("");
        }
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return Arrays.asList("script");
    }

    @Override
    public boolean supportsCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        return "script".equals(command);
    }
}

