/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.spring;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.Objects;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.integration.spring.SpringOptions;
import schemacrawler.tools.integration.spring.SpringOptionsParser;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public class SchemaCrawlerSpringCommandLine
implements CommandLine {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawlerSpringCommandLine.class.getName());
    private final SpringOptions springOptions;

    public SchemaCrawlerSpringCommandLine(Config argsMap) {
        Objects.requireNonNull(argsMap, "No command-line arguments provided");
        SpringOptionsParser springOptionsParser = new SpringOptionsParser(argsMap);
        this.springOptions = springOptionsParser.getOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        FileSystemXmlApplicationContext appContext;
        Path contextFile = Paths.get(this.springOptions.getContextFileName(), new String[0]).normalize().toAbsolutePath();
        if (Files.exists(contextFile, new LinkOption[0])) {
            String contextFilePath = contextFile.toUri().toString();
            LOGGER.log(Level.INFO, new StringFormat("Loading context from file <%s>", contextFilePath));
            appContext = new FileSystemXmlApplicationContext(contextFilePath);
        } else {
            LOGGER.log(Level.INFO, new StringFormat("Loading context from classpath <%s>", this.springOptions.getContextFileName()));
            appContext = new ClassPathXmlApplicationContext(this.springOptions.getContextFileName());
        }
        try {
            DataSource dataSource = (DataSource)appContext.getBean(this.springOptions.getDataSourceName());
            DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions = (DatabaseSpecificOverrideOptions)appContext.getBean(this.springOptions.getDatabaseSpecificOverrideOptionsName());
            try (Connection connection = dataSource.getConnection();){
                Executable executable = (Executable)appContext.getBean(this.springOptions.getExecutableName());
                if (databaseSpecificOverrideOptions == null) {
                    executable.execute(connection);
                } else {
                    executable.execute(connection, databaseSpecificOverrideOptions);
                }
            }
        }
        finally {
            ((AbstractXmlApplicationContext)appContext).close();
        }
    }
}

