/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.thymeleaf;

import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Connection;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.UrlTemplateResolver;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.executable.BaseStagedExecutable;

public final class ThymeleafRenderer
extends BaseStagedExecutable {
    static final String COMMAND = "thymeleaf";

    public ThymeleafRenderer() {
        super(COMMAND);
    }

    @Override
    public final void executeOn(Catalog catalog, Connection connection) throws Exception {
        Context context = new Context();
        context.setVariable("catalog", (Object)catalog);
        context.setVariable("identifiers", (Object)this.databaseSpecificOptions.getIdentifiers());
        TemplateEngine templateEngine = new TemplateEngine();
        Charset inputCharset = this.outputOptions.getInputCharset();
        FileTemplateResolver fileResolver = new FileTemplateResolver();
        fileResolver.setCheckExistence(true);
        templateEngine.addTemplateResolver(this.configure((AbstractConfigurableTemplateResolver)fileResolver, inputCharset));
        ClassLoaderTemplateResolver classpathResolver = new ClassLoaderTemplateResolver();
        classpathResolver.setCheckExistence(true);
        templateEngine.addTemplateResolver(this.configure((AbstractConfigurableTemplateResolver)classpathResolver, inputCharset));
        UrlTemplateResolver urlResolver = new UrlTemplateResolver();
        urlResolver.setCheckExistence(true);
        templateEngine.addTemplateResolver(this.configure((AbstractConfigurableTemplateResolver)urlResolver, inputCharset));
        String templateLocation = this.outputOptions.getOutputFormatValue();
        try (Writer writer = this.outputOptions.openNewOutputWriter();){
            templateEngine.process(templateLocation, (IContext)context, writer);
        }
    }

    private ITemplateResolver configure(AbstractConfigurableTemplateResolver templateResolver, Charset inputEncoding) {
        templateResolver.setCharacterEncoding(inputEncoding.name());
        templateResolver.setTemplateMode("HTML5");
        return templateResolver;
    }
}

