/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.velocity;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.integration.velocity.VelocityRenderer;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.iosource.StringInputResource;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;

public class VelocityCommandProvider
implements CommandProvider {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(VelocityCommandProvider.class.getName());

    @Override
    public Executable configureNewExecutable(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        VelocityRenderer executable = new VelocityRenderer();
        if (schemaCrawlerOptions != null) {
            executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        }
        if (outputOptions != null) {
            executable.setOutputOptions(outputOptions);
        }
        return executable;
    }

    @Override
    public InputResource getHelp() {
        String helpResource = "/help/VelocityRenderer.txt";
        try {
            return new ClasspathInputResource("/help/VelocityRenderer.txt");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Could not load help resource <%s>", "/help/VelocityRenderer.txt"), (Throwable)e);
            return new StringInputResource("");
        }
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return Arrays.asList("velocity");
    }

    @Override
    public boolean supportsCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        return "velocity".equals(command);
    }
}

