/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.iosource;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.tools.iosource.ConsoleOutputResource;
import sf.util.SchemaCrawlerLogger;

public final class OutputWriter
extends Writer {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ConsoleOutputResource.class.getName());
    private final String description;
    private final Writer writer;
    private final boolean shouldCloseWriter;
    private boolean isClosed;

    public OutputWriter(String description, Writer writer, boolean shouldCloseWriter) {
        this.description = Objects.requireNonNull(description, "No description provided");
        this.writer = Objects.requireNonNull(writer, "No writer provided");
        this.shouldCloseWriter = shouldCloseWriter;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.ensureOpen();
        return this.writer.append(c);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.ensureOpen();
        return this.writer.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.ensureOpen();
        return this.writer.append(csq, start, end);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.shouldCloseWriter) {
            LOGGER.log(Level.INFO, "Closing output writer");
            this.writer.close();
        } else {
            LOGGER.log(Level.INFO, "Not closing output writer, since output is to an externally provided writer");
        }
        this.isClosed = true;
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.writer.flush();
    }

    public String toString() {
        return this.description;
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.ensureOpen();
        this.writer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.ensureOpen();
        this.writer.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        this.ensureOpen();
        this.writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.ensureOpen();
        this.writer.write(str, off, len);
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            throw new IllegalStateException(String.format("Could not close output writer <%s>", this.description));
        }
        super.finalize();
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException(String.format("Output writer is not open <%s>", this.description));
        }
    }
}

