/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.util.List;
import java.util.logging.Level;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputFormatState;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public enum TextOutputFormat implements OutputFormat
{
    text("Plain text format", "txt"),
    html("HyperText Markup Language (HTML) format"),
    csv("Comma-separated values (CSV) format"),
    tsv("Tab-separated values (TSV) format"),
    json("JavaScript Object Notation (JSON) format");

    private static final SchemaCrawlerLogger LOGGER;
    private final OutputFormatState outputFormatState;

    public static TextOutputFormat fromFormat(String format) {
        TextOutputFormat outputFormat = TextOutputFormat.fromFormatOrNull(format);
        if (outputFormat == null) {
            LOGGER.log(Level.CONFIG, new StringFormat("Unknown format <%s>, using default", format));
            return text;
        }
        return outputFormat;
    }

    public static boolean isSupportedFormat(String format) {
        return TextOutputFormat.fromFormatOrNull(format) != null;
    }

    private static TextOutputFormat fromFormatOrNull(String format) {
        if (Utility.isBlank(format)) {
            return null;
        }
        for (TextOutputFormat outputFormat : TextOutputFormat.values()) {
            if (!outputFormat.outputFormatState.isSupportedFormat(format)) continue;
            return outputFormat;
        }
        return null;
    }

    private TextOutputFormat(String description) {
        this.outputFormatState = new OutputFormatState(this.name(), description, new String[0]);
    }

    private TextOutputFormat(String description, String ... additionalFormatSpecifiers) {
        this.outputFormatState = new OutputFormatState(this.name(), description, additionalFormatSpecifiers);
    }

    @Override
    public String getDescription() {
        return this.outputFormatState.getDescription();
    }

    @Override
    public String getFormat() {
        return this.outputFormatState.getFormat();
    }

    @Override
    public List<String> getFormats() {
        return this.outputFormatState.getFormats();
    }

    public String toString() {
        return this.outputFormatState.toString();
    }

    static {
        LOGGER = SchemaCrawlerLogger.getLogger(TextOutputFormat.class.getName());
    }
}

