/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.sql.Connection;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.CatalogWithAssociations;
import schemacrawler.tools.analysis.counts.CatalogWithCounts;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.schema.SchemaJsonFormatter;
import schemacrawler.tools.text.schema.SchemaListFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextFormatter;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.schema.SchemaTextOptionsBuilder;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import schemacrawler.utility.NamedObjectSort;

public final class SchemaTextExecutable
extends BaseStagedExecutable {
    private SchemaTextOptions schemaTextOptions;

    public SchemaTextExecutable(String command) {
        super(command);
    }

    @Override
    public void executeOn(Catalog db, Connection connection) throws Exception {
        this.loadSchemaTextOptions();
        Catalog catalog = db;
        if (this.schemaTextOptions.isShowWeakAssociations()) {
            catalog = new CatalogWithAssociations(catalog);
        }
        if (this.schemaTextOptions.isShowRowCounts() || this.schemaCrawlerOptions.isHideEmptyTables()) {
            catalog = new CatalogWithCounts(catalog, connection, this.schemaCrawlerOptions);
        }
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler();
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog(catalog);
        traverser.setHandler(formatter);
        traverser.setTablesComparator(NamedObjectSort.getNamedObjectSort(this.getSchemaTextOptions().isAlphabeticalSortForTables()));
        traverser.setRoutinesComparator(NamedObjectSort.getNamedObjectSort(this.getSchemaTextOptions().isAlphabeticalSortForRoutines()));
        traverser.traverse();
    }

    public final SchemaTextOptions getSchemaTextOptions() {
        this.loadSchemaTextOptions();
        return this.schemaTextOptions;
    }

    public final void setSchemaTextOptions(SchemaTextOptions schemaTextOptions) {
        this.schemaTextOptions = schemaTextOptions;
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = SchemaTextDetailType.schema;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler() throws SchemaCrawlerException {
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        String identifierQuoteString = this.databaseSpecificOptions.getIdentifierQuoteString();
        TextOutputFormat outputFormat = TextOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        BaseFormatter formatter = outputFormat == TextOutputFormat.json ? new SchemaJsonFormatter(schemaTextDetailType, this.schemaTextOptions, this.outputOptions, identifierQuoteString) : (schemaTextDetailType == SchemaTextDetailType.list ? new SchemaListFormatter(schemaTextDetailType, this.schemaTextOptions, this.outputOptions, identifierQuoteString) : new SchemaTextFormatter(schemaTextDetailType, this.schemaTextOptions, this.outputOptions, identifierQuoteString));
        return formatter;
    }

    private void loadSchemaTextOptions() {
        if (this.schemaTextOptions == null) {
            this.schemaTextOptions = (SchemaTextOptions)new SchemaTextOptionsBuilder().fromConfig(this.additionalConfiguration).toOptions();
        }
    }
}

