/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler;

import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.Version;
import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.commandline.ApplicationOptionsParser;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerHelpCommandLine;
import schemacrawler.tools.options.ApplicationOptions;
import us.fatehi.commandlineparser.CommandLineUtility;

public final class Main {
    public static void main(String[] args) throws Exception {
        Objects.requireNonNull(args, "No arguments provided");
        try {
            CommandLine commandLine;
            boolean showHelp;
            CommandLineUtility.applyApplicationLogLevel(Level.OFF);
            Config argsMap = CommandLineUtility.parseArgs(args);
            ApplicationOptionsParser applicationOptionsParser = new ApplicationOptionsParser(argsMap);
            ApplicationOptions applicationOptions = applicationOptionsParser.getOptions();
            CommandLineUtility.applyApplicationLogLevel(applicationOptions.getApplicationLogLevel());
            CommandLineUtility.logSafeArguments(args);
            CommandLineUtility.logSystemClasspath();
            CommandLineUtility.logSystemProperties();
            boolean bl = showHelp = args.length == 0 || args.length == 1 && Main.class.getCanonicalName().equals(args[0]) || applicationOptions.isShowHelp();
            if (showHelp) {
                boolean showVersionOnly = applicationOptions.isShowVersionOnly();
                commandLine = new SchemaCrawlerHelpCommandLine(argsMap, showVersionOnly);
            } else {
                commandLine = new SchemaCrawlerCommandLine(argsMap);
            }
            commandLine.execute();
        }
        catch (Throwable e) {
            System.err.printf("%s %s%n%n", Version.getProductName(), Version.getVersion());
            String errorMessage = e.getMessage();
            System.err.print("Error: ");
            System.err.println(errorMessage);
            System.err.println();
            System.err.println("Re-run SchemaCrawler with just the\n-?\noption for help");
            System.err.println();
            System.err.println("Or, re-run SchemaCrawler with an additional\n-loglevel=CONFIG\noption for details on the error");
            CommandLineUtility.logSafeArguments(args);
            CommandLineUtility.logFullStackTrace(Level.SEVERE, e);
        }
    }

    private Main() {
    }
}

