/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.TableReference;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableConstraintType;

class MutableTableConstraint
extends AbstractDependantObject<Table>
implements TableConstraint {
    private static final long serialVersionUID = 1155277343302693656L;
    private final NamedObjectList<MutableTableConstraintColumn> columns = new NamedObjectList();
    private TableConstraintType tableConstraintType;
    private boolean deferrable;
    private boolean initiallyDeferred;
    private final StringBuilder definition = new StringBuilder();

    MutableTableConstraint(Table parent, String name) {
        super(new TableReference(parent), name);
    }

    @Override
    public List<TableConstraintColumn> getColumns() {
        return new ArrayList<TableConstraintColumn>(this.columns.values());
    }

    @Override
    public TableConstraintType getConstraintType() {
        return this.tableConstraintType;
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public TableConstraintType getType() {
        return this.getConstraintType();
    }

    @Override
    public boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public boolean isDeferrable() {
        return this.deferrable;
    }

    @Override
    public boolean isInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setTableConstraintType(TableConstraintType tableConstraintType) {
        this.tableConstraintType = tableConstraintType;
    }

    void addColumn(MutableTableConstraintColumn column) {
        this.columns.add(column);
    }

    void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    void setDeferrable(boolean deferrable) {
        this.deferrable = deferrable;
    }

    void setInitiallyDeferred(boolean initiallyDeferred) {
        this.initiallyDeferred = initiallyDeferred;
    }
}

