/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.JvmSystemInfo;
import schemacrawler.OperatingSystemInfo;
import schemacrawler.SchemaCrawlerInfo;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Reducer;
import schemacrawler.schema.Reducible;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;

public abstract class BaseCatalogDecorator
implements Catalog,
Reducible {
    private static final long serialVersionUID = -3953296149824921463L;
    protected final Catalog catalog;

    protected BaseCatalogDecorator(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    @Override
    public int compareTo(NamedObject o) {
        return this.catalog.compareTo(o);
    }

    @Override
    public <T> T getAttribute(String name, T defaultValue) {
        return this.catalog.getAttribute(name, defaultValue);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.catalog.getAttributes();
    }

    @Override
    public Collection<ColumnDataType> getColumnDataTypes() {
        return this.catalog.getColumnDataTypes();
    }

    @Override
    public Collection<ColumnDataType> getColumnDataTypes(Schema schema) {
        return this.catalog.getColumnDataTypes(schema);
    }

    @Override
    public CrawlInfo getCrawlInfo() {
        return this.catalog.getCrawlInfo();
    }

    @Override
    public DatabaseInfo getDatabaseInfo() {
        return this.catalog.getDatabaseInfo();
    }

    @Override
    public String getFullName() {
        return this.catalog.getFullName();
    }

    @Override
    public JdbcDriverInfo getJdbcDriverInfo() {
        return this.catalog.getJdbcDriverInfo();
    }

    @Override
    public JvmSystemInfo getJvmSystemInfo() {
        return this.catalog.getJvmSystemInfo();
    }

    @Override
    public String getName() {
        return this.catalog.getName();
    }

    @Override
    public OperatingSystemInfo getOperatingSystemInfo() {
        return this.catalog.getOperatingSystemInfo();
    }

    @Override
    public String getRemarks() {
        return this.catalog.getRemarks();
    }

    @Override
    public Collection<Routine> getRoutines() {
        return this.catalog.getRoutines();
    }

    @Override
    public Collection<Routine> getRoutines(Schema schema) {
        return this.catalog.getRoutines(schema);
    }

    @Override
    public SchemaCrawlerInfo getSchemaCrawlerInfo() {
        return this.catalog.getSchemaCrawlerInfo();
    }

    @Override
    public Collection<Schema> getSchemas() {
        return this.catalog.getSchemas();
    }

    @Override
    public Collection<Sequence> getSequences() {
        return this.catalog.getSequences();
    }

    @Override
    public Collection<Sequence> getSequences(Schema schema) {
        return this.catalog.getSequences(schema);
    }

    @Override
    public Collection<Synonym> getSynonyms() {
        return this.catalog.getSynonyms();
    }

    @Override
    public Collection<Synonym> getSynonyms(Schema schema) {
        return this.catalog.getSynonyms(schema);
    }

    @Override
    public Collection<ColumnDataType> getSystemColumnDataTypes() {
        return this.catalog.getSystemColumnDataTypes();
    }

    @Override
    public Collection<Table> getTables() {
        return this.catalog.getTables();
    }

    @Override
    public Collection<Table> getTables(Schema schema) {
        return this.catalog.getTables(schema);
    }

    @Override
    public boolean hasAttribute(String name) {
        return false;
    }

    @Override
    public boolean hasRemarks() {
        return this.catalog.hasRemarks();
    }

    public Optional<? extends ColumnDataType> lookupColumnDataType(Schema schema, String name) {
        return this.catalog.lookupColumnDataType(schema, name);
    }

    public Optional<? extends Routine> lookupRoutine(Schema schema, String name) {
        return this.catalog.lookupRoutine(schema, name);
    }

    public Optional<? extends Schema> lookupSchema(String name) {
        return this.catalog.lookupSchema(name);
    }

    public Optional<? extends Sequence> lookupSequence(Schema schema, String name) {
        return this.catalog.lookupSequence(schema, name);
    }

    public Optional<? extends Synonym> lookupSynonym(Schema schema, String name) {
        return this.catalog.lookupSynonym(schema, name);
    }

    public Optional<? extends ColumnDataType> lookupSystemColumnDataType(String name) {
        return this.catalog.lookupSystemColumnDataType(name);
    }

    public Optional<? extends Table> lookupTable(Schema schema, String name) {
        return this.catalog.lookupTable(schema, name);
    }

    @Override
    public <N extends NamedObject> void reduce(Class<N> clazz, Reducer<N> reducer) {
        ((Reducible)((Object)this.catalog)).reduce(clazz, reducer);
    }

    @Override
    public void removeAttribute(String name) {
        this.catalog.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.catalog.setAttribute(name, value);
    }

    @Override
    public List<String> toUniqueLookupKey() {
        return this.catalog.toUniqueLookupKey();
    }
}

