/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.logging.Level;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.InclusionRuleWithRegularExpression;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class RegularExpressionRule
implements InclusionRuleWithRegularExpression {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RegularExpressionRule.class.getName());
    private static final long serialVersionUID = 3443758881974362293L;
    private final Pattern patternInclude;
    private final Pattern patternExclude;

    public RegularExpressionRule(Pattern patternInclude, Pattern patternExclude) {
        this.patternInclude = patternInclude == null ? InclusionRuleWithRegularExpression.super.getInclusionPattern() : patternInclude;
        this.patternExclude = patternExclude == null ? InclusionRuleWithRegularExpression.super.getExclusionPattern() : patternExclude;
    }

    public RegularExpressionRule(String patternInclude, String patternExclude) {
        this(patternInclude == null ? null : Pattern.compile(patternInclude), patternExclude == null ? null : Pattern.compile(patternExclude));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegularExpressionRule other = (RegularExpressionRule)obj;
        if (this.patternExclude == null ? other.patternExclude != null : !this.patternExclude.pattern().equals(other.patternExclude.pattern())) {
            return false;
        }
        return !(this.patternInclude == null ? other.patternInclude != null : !this.patternInclude.pattern().equals(other.patternInclude.pattern()));
    }

    @Override
    public Pattern getExclusionPattern() {
        return this.patternExclude;
    }

    @Override
    public Pattern getInclusionPattern() {
        return this.patternInclude;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.patternExclude == null ? 0 : this.patternExclude.hashCode());
        result = 31 * result + (this.patternInclude == null ? 0 : this.patternInclude.hashCode());
        return result;
    }

    @Override
    public boolean test(String text) {
        StringFormat actionMessage;
        boolean include = false;
        if (!Utility.isBlank(text)) {
            if (!this.patternInclude.matcher(text).matches()) {
                actionMessage = new StringFormat("Excluding <%s> since it does not match /%s/", text, this.patternInclude.pattern());
            } else if (this.patternExclude.matcher(text).matches()) {
                actionMessage = new StringFormat("Excluding <%s> since it matches /%s/", text, this.patternExclude.pattern());
            } else {
                actionMessage = new StringFormat("Including <%s> since it matches /%s/", text, this.patternInclude.pattern());
                include = true;
            }
        } else {
            actionMessage = new StringFormat("Excluding, since text is bank", new Object[0]);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, 5, (String)actionMessage.get(), null);
        }
        return include;
    }

    public String toString() {
        return String.format("%s@%h {+/%s/ -/%s/}", this.getClass().getSimpleName(), System.identityHashCode(this), this.patternInclude.pattern(), this.patternExclude.pattern());
    }
}

