/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaInfoRetrieval;
import sf.util.Utility;

public final class SchemaInfoLevel
implements Options {
    private final String tag;
    private final Map<SchemaInfoRetrieval, Boolean> schemaInfoRetrievals;

    SchemaInfoLevel(String tag, Map<SchemaInfoRetrieval, Boolean> schemaInfoRetrievals) {
        Objects.requireNonNull(tag, "No tag provided");
        this.tag = tag;
        Objects.requireNonNull(schemaInfoRetrievals, "No schema info retrievals provided");
        this.schemaInfoRetrievals = new HashMap<SchemaInfoRetrieval, Boolean>(schemaInfoRetrievals);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaInfoLevel)) {
            return false;
        }
        SchemaInfoLevel other = (SchemaInfoLevel)obj;
        return Objects.equals(this.schemaInfoRetrievals, other.schemaInfoRetrievals) && Objects.equals(this.tag, other.tag);
    }

    public String getTag() {
        return this.tag;
    }

    public int hashCode() {
        return Objects.hash(this.schemaInfoRetrievals, this.tag);
    }

    public boolean isRetrieveAdditionalColumnAttributes() {
        return this.is(SchemaInfoRetrieval.retrieveAdditionalColumnAttributes);
    }

    public boolean isRetrieveAdditionalDatabaseInfo() {
        return this.is(SchemaInfoRetrieval.retrieveAdditionalDatabaseInfo);
    }

    public boolean isRetrieveAdditionalJdbcDriverInfo() {
        return this.is(SchemaInfoRetrieval.retrieveAdditionalJdbcDriverInfo);
    }

    public boolean isRetrieveAdditionalTableAttributes() {
        return this.is(SchemaInfoRetrieval.retrieveAdditionalTableAttributes);
    }

    public boolean isRetrieveColumnDataTypes() {
        return this.is(SchemaInfoRetrieval.retrieveColumnDataTypes);
    }

    public boolean isRetrieveDatabaseInfo() {
        return this.is(SchemaInfoRetrieval.retrieveDatabaseInfo);
    }

    public boolean isRetrieveForeignKeyDefinitions() {
        return this.is(SchemaInfoRetrieval.retrieveForeignKeyDefinitions);
    }

    public boolean isRetrieveForeignKeys() {
        return this.is(SchemaInfoRetrieval.retrieveForeignKeys);
    }

    public boolean isRetrieveIndexColumnInformation() {
        return this.is(SchemaInfoRetrieval.retrieveIndexColumnInformation);
    }

    public boolean isRetrieveIndexes() {
        return this.is(SchemaInfoRetrieval.retrieveIndexes);
    }

    public boolean isRetrieveIndexInformation() {
        return this.is(SchemaInfoRetrieval.retrieveIndexInformation);
    }

    public boolean isRetrievePrimaryKeyDefinitions() {
        return this.is(SchemaInfoRetrieval.retrievePrimaryKeyDefinitions);
    }

    public boolean isRetrieveRoutineColumns() {
        return this.is(SchemaInfoRetrieval.retrieveRoutineColumns);
    }

    public boolean isRetrieveRoutineInformation() {
        return this.is(SchemaInfoRetrieval.retrieveRoutineInformation);
    }

    public boolean isRetrieveRoutines() {
        return this.is(SchemaInfoRetrieval.retrieveRoutines);
    }

    public boolean isRetrieveSequenceInformation() {
        return this.is(SchemaInfoRetrieval.retrieveSequenceInformation);
    }

    public boolean isRetrieveServerInfo() {
        return this.is(SchemaInfoRetrieval.retrieveServerInfo);
    }

    public boolean isRetrieveSynonymInformation() {
        return this.is(SchemaInfoRetrieval.retrieveSynonymInformation);
    }

    public boolean isRetrieveTableColumnPrivileges() {
        return this.is(SchemaInfoRetrieval.retrieveTableColumnPrivileges);
    }

    public boolean isRetrieveTableColumns() {
        return this.is(SchemaInfoRetrieval.retrieveTableColumns);
    }

    public boolean isRetrieveTableConstraintDefinitions() {
        return this.is(SchemaInfoRetrieval.retrieveTableConstraintDefinitions);
    }

    public boolean isRetrieveTableConstraintInformation() {
        return this.is(SchemaInfoRetrieval.retrieveTableConstraintInformation);
    }

    public boolean isRetrieveTableDefinitionsInformation() {
        return this.is(SchemaInfoRetrieval.retrieveTableDefinitionsInformation);
    }

    public boolean isRetrieveTablePrivileges() {
        return this.is(SchemaInfoRetrieval.retrieveTablePrivileges);
    }

    public boolean isRetrieveTables() {
        return this.is(SchemaInfoRetrieval.retrieveTables);
    }

    public boolean isRetrieveTriggerInformation() {
        return this.is(SchemaInfoRetrieval.retrieveTriggerInformation);
    }

    public boolean isRetrieveUserDefinedColumnDataTypes() {
        return this.is(SchemaInfoRetrieval.retrieveUserDefinedColumnDataTypes);
    }

    public boolean isRetrieveViewInformation() {
        return this.is(SchemaInfoRetrieval.retrieveViewInformation);
    }

    public String toString() {
        HashMap<String, String> completeMap = new HashMap<String, String>();
        for (SchemaInfoRetrieval schemaInfoRetrieval : SchemaInfoRetrieval.values()) {
            completeMap.put(schemaInfoRetrieval.name(), String.valueOf(this.is(schemaInfoRetrieval)));
        }
        return String.format("SchemaInfoLevel <%s>%n%s", this.tag, Utility.join(completeMap, "\n"));
    }

    private Boolean is(SchemaInfoRetrieval schemaInfoRetrieval) {
        if (schemaInfoRetrieval == null) {
            return false;
        }
        return this.schemaInfoRetrievals.getOrDefault((Object)schemaInfoRetrieval, false);
    }
}

