/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import schemacrawler.schema.Column;
import schemacrawler.schema.Index;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Table;

final class TableCandidateKeys
implements Iterable<Column> {
    private final Table table;
    private final Set<Column> tableKeys;

    TableCandidateKeys(Table table) {
        this.table = Objects.requireNonNull(table, "No table provided");
        this.tableKeys = this.listTableKeys(table);
    }

    @Override
    public Iterator<Column> iterator() {
        return this.tableKeys.iterator();
    }

    public String toString() {
        return String.format("%s: %s", this.table, this.tableKeys);
    }

    private Set<Column> listTableKeys(Table table) {
        HashSet<Column> tableKeys = new HashSet<Column>();
        PrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey != null && primaryKey.getColumns().size() == 1) {
            tableKeys.add(primaryKey.getColumns().get(0));
        }
        for (Index index : table.getIndexes()) {
            if (index == null || !index.isUnique() || index.getColumns().size() != 1) continue;
            tableKeys.add(index.getColumns().get(0));
        }
        return tableKeys;
    }
}

