/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.counts;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.BaseCatalogDecorator;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.analysis.counts.CountsUtility;
import schemacrawler.tools.analysis.counts.TableCountFilter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.utility.Identifiers;
import schemacrawler.utility.Query;
import schemacrawler.utility.QueryUtility;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class CatalogWithCounts
extends BaseCatalogDecorator {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(CatalogWithCounts.class.getName());
    private static final long serialVersionUID = -3953296149824921463L;
    private final Map<Table, Long> counts = new HashMap<Table, Long>();

    public CatalogWithCounts(Catalog catalog, Connection connection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        super(catalog);
        Identifiers identifiers;
        try {
            DatabaseUtility.checkConnection(connection);
            identifiers = Identifiers.identifiers().withConnection(connection).build();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "No connection provided", (Throwable)e);
            Identifiers identifiers2 = Identifiers.identifiers().withIdentifierQuoteString("\"").build();
            return;
        }
        Query query = Operation.count.getQuery();
        ArrayList<Table> allTables = new ArrayList<Table>(catalog.getTables());
        for (Table table : allTables) {
            try {
                long count = QueryUtility.executeForLong(query, connection, table, identifiers);
                this.counts.put(table, count);
                CountsUtility.addRowCountToTable(table, count);
            }
            catch (SchemaCrawlerException e) {
                LOGGER.log(Level.WARNING, new StringFormat("Could not get count for table <%s>", table), (Throwable)e);
            }
        }
        this.reduce(Table.class, ReducerFactory.getTableReducer(new TableCountFilter(options)));
    }

    @Override
    public final <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public Map<Table, Long> getCounts() {
        return this.counts;
    }

    @Override
    public final <T> Optional<T> lookupAttribute(String name) {
        return Optional.of(this.getAttribute(name));
    }
}

