/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.sql.Connection;
import java.util.logging.Level;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerCommandLineException;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.schemacrawler.UserCredentials;
import schemacrawler.tools.commandline.AdditionalConfigOptionsParser;
import schemacrawler.tools.commandline.BaseDatabaseConnectionOptionsParser;
import schemacrawler.tools.commandline.BundledDriverConnectionOptionsParser;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.CommandLineConnectionOptionsParser;
import schemacrawler.tools.commandline.CommandParser;
import schemacrawler.tools.commandline.DatabaseServerTypeParser;
import schemacrawler.tools.commandline.OutputOptionsParser;
import schemacrawler.tools.commandline.SchemaCrawlerOptionsParser;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import us.fatehi.commandlineparser.CommandLineUtility;

public final class SchemaCrawlerCommandLine
implements CommandLine {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawlerCommandLine.class.getName());
    private final String command;
    private final Config config;
    private final SchemaCrawlerOptions schemaCrawlerOptions;
    private final OutputOptions outputOptions;
    private final ConnectionOptions connectionOptions;
    private final DatabaseConnector databaseConnector;

    public SchemaCrawlerCommandLine(Config argsMap) throws SchemaCrawlerException {
        if (argsMap == null || argsMap.isEmpty()) {
            throw new SchemaCrawlerCommandLineException("Please provide command-line arguments");
        }
        DatabaseServerTypeParser dbServerTypeParser = new DatabaseServerTypeParser(argsMap);
        this.databaseConnector = dbServerTypeParser.getOptions();
        LOGGER.log(Level.INFO, new StringFormat("Using database plugin <%s>", this.databaseConnector.getDatabaseServerType()));
        this.config = this.loadConfig(argsMap);
        CommandParser commandParser = new CommandParser(this.config);
        this.command = commandParser.getOptions().toString();
        SchemaCrawlerOptionsParser schemaCrawlerOptionsParser = new SchemaCrawlerOptionsParser(this.config);
        this.schemaCrawlerOptions = schemaCrawlerOptionsParser.getOptions();
        OutputOptionsParser outputOptionsParser = new OutputOptionsParser(this.config);
        this.outputOptions = outputOptionsParser.getOptions();
        AdditionalConfigOptionsParser additionalConfigOptionsParser = new AdditionalConfigOptionsParser(this.config);
        additionalConfigOptionsParser.loadConfig();
        UserCredentials userCredentials = this.parseConnectionOptions();
        this.connectionOptions = this.databaseConnector.newDatabaseConnectionOptions(userCredentials, this.config);
    }

    @Override
    public void execute() throws Exception {
        if (this.connectionOptions == null) {
            throw new SchemaCrawlerException("No connection options provided");
        }
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable(this.command);
        executable.setOutputOptions(this.outputOptions);
        executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        executable.setAdditionalConfiguration(this.config);
        try (Connection connection = this.connectionOptions.getConnection();){
            SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = this.databaseConnector.getSchemaRetrievalOptionsBuilder(connection);
            schemaRetrievalOptionsBuilder.fromConfig(this.config);
            SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
            executable.setConnection(connection);
            executable.setSchemaRetrievalOptions(schemaRetrievalOptions);
            executable.execute();
        }
    }

    public final String getCommand() {
        return this.command;
    }

    public final Config getConfig() {
        return this.config;
    }

    public final ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    public final SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    private Config loadConfig(Config argsMap) throws SchemaCrawlerException {
        return CommandLineUtility.loadConfig(argsMap, this.databaseConnector);
    }

    private UserCredentials parseConnectionOptions() throws SchemaCrawlerException {
        BaseDatabaseConnectionOptionsParser dbConnectionOptionsParser = this.databaseConnector.isUnknownDatabaseSystem() || this.config.hasValue("url") ? new CommandLineConnectionOptionsParser(this.config) : new BundledDriverConnectionOptionsParser(this.config);
        dbConnectionOptionsParser.loadConfig();
        this.config.putAll(dbConnectionOptionsParser.getOptions());
        UserCredentials userCredentials = dbConnectionOptionsParser.getUserCredentials();
        return userCredentials;
    }
}

