/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import schemacrawler.schema.Property;
import sf.util.Utility;

public final class CommandDescription
implements Property {
    private static final long serialVersionUID = 2444083929278551904L;
    private final String name;
    private final String description;

    public CommandDescription(String name, String description) {
        if (Utility.isBlank(name)) {
            throw new IllegalArgumentException("Command name not provided");
        }
        this.name = name;
        this.description = Utility.isBlank(description) ? null : description;
    }

    @Override
    public int compareTo(Property otherProperty) {
        if (otherProperty == null) {
            return -1;
        }
        return this.getName().toLowerCase().compareTo(otherProperty.getName().toLowerCase());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandDescription)) {
            return false;
        }
        CommandDescription other = (CommandDescription)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.getDescription();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        if (this.description != null) {
            builder.append(" - ").append(this.description);
        }
        return builder.toString();
    }
}

