/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerCommandLineException;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.OperationExecutableCommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.executable.SchemaExecutableCommandProvider;
import schemacrawler.tools.iosource.EmptyInputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class CommandRegistry
implements Iterable<CommandDescription> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(CommandRegistry.class.getName());
    private final List<CommandProvider> commandRegistry = CommandRegistry.loadCommandRegistry();

    private static List<CommandProvider> loadCommandRegistry() throws SchemaCrawlerException {
        ArrayList<CommandProvider> commandProviders = new ArrayList<CommandProvider>();
        commandProviders.add(new SchemaExecutableCommandProvider());
        commandProviders.add(new OperationExecutableCommandProvider());
        try {
            ServiceLoader<CommandProvider> serviceLoader = ServiceLoader.load(CommandProvider.class);
            for (CommandProvider commandProvider : serviceLoader) {
                LOGGER.log(Level.CONFIG, new StringFormat("Loading commands %s, provided by %s", commandProvider.getSupportedCommands(), commandProvider.getClass().getName()));
                commandProviders.add(commandProvider);
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load extended command registry", e);
        }
        return commandProviders;
    }

    public InputResource getHelp(String command) {
        for (CommandProvider commandProvider : this.commandRegistry) {
            if (!commandProvider.getSupportedCommands().contains(command)) continue;
            return commandProvider.getHelp();
        }
        return new EmptyInputResource();
    }

    public boolean isCommandSupported(String command) {
        for (CommandProvider commandProvider : this.commandRegistry) {
            for (String supportedCommand : commandProvider.getSupportedCommands()) {
                if (!supportedCommand.equalsIgnoreCase(command)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<CommandDescription> iterator() {
        return this.getSupportedCommands().iterator();
    }

    SchemaCrawlerCommand configureNewCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) throws SchemaCrawlerException {
        SchemaCrawlerCommand scCommand;
        CommandProvider executableCommandProvider = null;
        for (CommandProvider commandProvider : this.commandRegistry) {
            if (!commandProvider.supportsSchemaCrawlerCommand(command, schemaCrawlerOptions, outputOptions)) continue;
            executableCommandProvider = commandProvider;
            break;
        }
        if (executableCommandProvider == null) {
            executableCommandProvider = new OperationExecutableCommandProvider();
        }
        try {
            scCommand = executableCommandProvider.newSchemaCrawlerCommand(command);
            scCommand.setSchemaCrawlerOptions(schemaCrawlerOptions);
            scCommand.setOutputOptions(outputOptions);
        }
        catch (Throwable e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
            throw new SchemaCrawlerCommandLineException(String.format("Cannot run command <%s>", command));
        }
        return scCommand;
    }

    private Collection<CommandDescription> getSupportedCommands() {
        HashSet<CommandDescription> supportedCommandDescriptions = new HashSet<CommandDescription>();
        for (CommandProvider commandProvider : this.commandRegistry) {
            String description = commandProvider.getDescription();
            for (String command : commandProvider.getSupportedCommands()) {
                supportedCommandDescriptions.add(new CommandDescription(command, description));
            }
        }
        ArrayList<CommandDescription> supportedCommandsOrdered = new ArrayList<CommandDescription>(supportedCommandDescriptions);
        Collections.sort(supportedCommandsOrdered);
        return supportedCommandsOrdered;
    }
}

