/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Reducible;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.tools.catalogloader.CatalogLoader;
import schemacrawler.tools.catalogloader.CatalogLoaderRegistry;
import schemacrawler.tools.executable.CommandDaisyChain;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.utility.SchemaCrawlerUtility;
import sf.util.ObjectToString;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class SchemaCrawlerExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawlerExecutable.class.getName());
    private final String command;
    private SchemaCrawlerOptions schemaCrawlerOptions;
    private OutputOptions outputOptions;
    private Config additionalConfiguration;
    private SchemaRetrievalOptions schemaRetrievalOptions;
    private Connection connection;

    public SchemaCrawlerExecutable(String command) {
        if (Utility.isBlank(command)) {
            throw new IllegalArgumentException("No command specified");
        }
        this.command = command;
        this.schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        this.outputOptions = OutputOptionsBuilder.newOutputOptions();
        this.additionalConfiguration = new Config();
    }

    public final void execute() throws Exception {
        Objects.requireNonNull(this.connection, "No connection provided");
        if (this.schemaRetrievalOptions == null) {
            this.schemaRetrievalOptions = SchemaCrawlerUtility.matchSchemaRetrievalOptions(this.connection);
        }
        this.logExecution();
        SchemaCrawlerCommand scCommand = this.loadCommand();
        scCommand.initialize();
        scCommand.checkAvailibility();
        Catalog catalog = this.loadCatalog();
        this.reduceCatalog(catalog);
        scCommand.setCatalog(catalog);
        scCommand.setConnection(this.connection);
        LOGGER.log(Level.INFO, new StringFormat("Executing command <%s> using <%s>", this.command, scCommand.getClass().getName()));
        scCommand.execute();
    }

    public boolean hasConnection() {
        if (this.connection == null) {
            return false;
        }
        try {
            boolean closed = this.connection.isClosed();
            return !closed;
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public final void setAdditionalConfiguration(Config additionalConfiguration) {
        this.additionalConfiguration = new Config(additionalConfiguration);
    }

    public void setConnection(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "No connection provided");
    }

    public final void setOutputOptions(OutputOptions outputOptions) {
        this.outputOptions = outputOptions == null ? OutputOptionsBuilder.newOutputOptions() : outputOptions;
    }

    public final void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions == null ? SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions() : schemaCrawlerOptions;
    }

    public void setSchemaRetrievalOptions(SchemaRetrievalOptions schemaRetrievalOptions) {
        this.schemaRetrievalOptions = schemaRetrievalOptions;
    }

    public final String toString() {
        return ObjectToString.toString(this);
    }

    private Catalog loadCatalog() throws Exception {
        CatalogLoaderRegistry catalogLoaderRegistry = new CatalogLoaderRegistry();
        CatalogLoader catalogLoader = catalogLoaderRegistry.lookupCatalogLoader(this.schemaRetrievalOptions.getDatabaseServerType().getDatabaseSystemIdentifier());
        LOGGER.log(Level.CONFIG, new StringFormat("Catalog loader: %s", this.getClass().getName()));
        catalogLoader.setAdditionalConfiguration(this.additionalConfiguration);
        catalogLoader.setConnection(this.connection);
        catalogLoader.setSchemaRetrievalOptions(this.schemaRetrievalOptions);
        catalogLoader.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        Catalog catalog = catalogLoader.loadCatalog();
        Objects.requireNonNull(catalog, "Catalog could not be retrieved");
        return catalog;
    }

    private SchemaCrawlerCommand loadCommand() throws SchemaCrawlerException {
        CommandDaisyChain scCommand = new CommandDaisyChain(this.command);
        scCommand.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        scCommand.setOutputOptions(this.outputOptions);
        scCommand.setAdditionalConfiguration(this.additionalConfiguration);
        scCommand.setIdentifiers(this.schemaRetrievalOptions.getIdentifiers());
        return scCommand;
    }

    private void logExecution() {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, String.format("Executing SchemaCrawler command <%s>", this.command));
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.log(Level.CONFIG, String.format("Executable: %s", this.getClass().getName()));
                LOGGER.log(Level.CONFIG, ObjectToString.toString(this.schemaCrawlerOptions));
                LOGGER.log(Level.CONFIG, ObjectToString.toString(this.outputOptions));
                LOGGER.log(Level.CONFIG, this.schemaRetrievalOptions.toString());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, ObjectToString.toString(this.additionalConfiguration));
                }
            }
        }
    }

    private void reduceCatalog(Catalog catalog) {
        ((Reducible)((Object)catalog)).reduce(Schema.class, ReducerFactory.getSchemaReducer(this.schemaCrawlerOptions));
        ((Reducible)((Object)catalog)).reduce(Table.class, ReducerFactory.getTableReducer(this.schemaCrawlerOptions));
        ((Reducible)((Object)catalog)).reduce(Routine.class, ReducerFactory.getRoutineReducer(this.schemaCrawlerOptions));
        ((Reducible)((Object)catalog)).reduce(Synonym.class, ReducerFactory.getSynonymReducer(this.schemaCrawlerOptions));
        ((Reducible)((Object)catalog)).reduce(Sequence.class, ReducerFactory.getSequenceReducer(this.schemaCrawlerOptions));
    }
}

