/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class FreeMarkerRenderer
extends BaseSchemaCrawlerCommand {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(FreeMarkerRenderer.class.getName());
    static final String COMMAND = "freemarker";

    public FreeMarkerRenderer() {
        super(COMMAND);
    }

    @Override
    public void checkAvailibility() throws Exception {
    }

    @Override
    public final void execute() throws Exception {
        this.checkCatalog();
        String templateLocation = this.outputOptions.getOutputFormatValue();
        String templatePath = ".";
        File templateFilePath = new File(templateLocation);
        if (templateFilePath.exists()) {
            templatePath = templateFilePath.getAbsoluteFile().getParent();
            templateLocation = templateFilePath.getName();
        }
        System.setProperty("org.freemarker.loggerLibrary", "JUL");
        LOGGER.log(Level.INFO, new StringFormat("Rendering using FreeMarker, version %s" + Configuration.getVersion().toString(), new Object[0]));
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        ClassTemplateLoader ctl = new ClassTemplateLoader(FreeMarkerRenderer.class, "/");
        FileTemplateLoader ftl = new FileTemplateLoader(new File(templatePath));
        MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{ctl, ftl});
        cfg.setTemplateLoader((TemplateLoader)mtl);
        cfg.setEncoding(Locale.getDefault(), this.outputOptions.getInputCharset().name());
        cfg.setWhitespaceStripping(true);
        LOGGER.log(Level.CONFIG, new StringFormat("FreeMarker configuration properties <%s>", cfg));
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("catalog", this.catalog);
        context.put("identifiers", this.identifiers);
        try (Writer writer = this.outputOptions.openNewOutputWriter();){
            Template template = cfg.getTemplate(templateLocation);
            template.process(context, writer);
        }
    }

    @Override
    public boolean usesConnection() {
        return true;
    }
}

