/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerCommandLineException;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.CatalogWithAssociations;
import schemacrawler.tools.analysis.counts.CatalogWithCounts;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.integration.graph.GraphExecutor;
import schemacrawler.tools.integration.graph.GraphJavaExecutor;
import schemacrawler.tools.integration.graph.GraphNoOpExecutor;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.integration.graph.GraphOptionsBuilder;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.integration.graph.GraphProcessExecutor;
import schemacrawler.tools.integration.graph.GraphvizJavaExecutorUtility;
import schemacrawler.tools.integration.graph.GraphvizUtility;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.tools.text.schema.SchemaDotFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import schemacrawler.utility.NamedObjectSort;
import sf.util.IOUtility;

public final class GraphRenderer
extends BaseSchemaCrawlerCommand {
    private GraphOptions graphOptions;
    private GraphOutputFormat graphOutputFormat;

    public GraphRenderer(String command) {
        super(command);
    }

    @Override
    public void checkAvailibility() throws Exception {
        if (this.graphOutputFormat == GraphOutputFormat.scdot) {
            return;
        }
        if (GraphvizUtility.isGraphvizAvailable()) {
            return;
        }
        if (GraphvizJavaExecutorUtility.isGraphvizJavaAvailable(this.graphOutputFormat)) {
            return;
        }
        throw new SchemaCrawlerException(String.format("Cannot generate graph in %s output format", this.graphOutputFormat));
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        Catalog aCatalog = this.catalog;
        if (this.graphOptions.isShowWeakAssociations()) {
            aCatalog = new CatalogWithAssociations(aCatalog);
        }
        if (this.graphOptions.isShowRowCounts() || this.schemaCrawlerOptions.isNoEmptyTables()) {
            aCatalog = new CatalogWithCounts(aCatalog, this.connection, this.schemaCrawlerOptions);
        }
        this.outputOptions = OutputOptionsBuilder.builder(this.outputOptions).withOutputFormat(this.graphOutputFormat).withOutputFormatValue(this.graphOutputFormat.getFormat()).toOptions();
        Path dotFile = IOUtility.createTempFilePath("schemacrawler.", "dot");
        OutputOptions dotFileOutputOptions = this.graphOutputFormat == GraphOutputFormat.scdot ? this.outputOptions : OutputOptionsBuilder.newOutputOptions((OutputFormat)GraphOutputFormat.dot, dotFile);
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler(dotFileOutputOptions);
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog(aCatalog);
        traverser.setHandler(formatter);
        traverser.setTablesComparator(NamedObjectSort.getNamedObjectSort(this.graphOptions.isAlphabeticalSortForTables()));
        traverser.setRoutinesComparator(NamedObjectSort.getNamedObjectSort(this.graphOptions.isAlphabeticalSortForRoutines()));
        traverser.traverse();
        GraphExecutor graphExecutor = this.getGraphExecutor(dotFile);
        graphExecutor.call();
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.loadGraphOptions();
    }

    public final void setGraphOptions(GraphOptions graphOptions) {
        this.graphOptions = Objects.requireNonNull(graphOptions, "No graph options provided");
    }

    @Override
    public boolean usesConnection() {
        return false;
    }

    private GraphExecutor getGraphExecutor(Path dotFile) throws SchemaCrawlerException {
        GraphExecutor graphExecutor;
        this.outputOptions = OutputOptionsBuilder.builder(this.outputOptions).withOutputFormat(this.graphOutputFormat).withOutputFormatValue(this.graphOutputFormat.getFormat()).toOptions();
        Path outputFile = this.outputOptions.getOutputFile().orElseGet(() -> Paths.get(".", String.format("schemacrawler-%s.%s", UUID.randomUUID(), this.outputOptions.getOutputFormatValue()))).normalize().toAbsolutePath();
        if (this.graphOutputFormat != GraphOutputFormat.scdot) {
            List<String> graphvizOpts = this.graphOptions.getGraphvizOpts();
            boolean graphExecutorAvailable = false;
            graphExecutor = new GraphProcessExecutor(dotFile, outputFile, this.graphOutputFormat, graphvizOpts);
            graphExecutorAvailable = graphExecutor.canGenerate();
            if (!graphExecutorAvailable) {
                graphExecutor = new GraphJavaExecutor(dotFile, outputFile, this.graphOutputFormat);
                graphExecutorAvailable = graphExecutor.canGenerate();
            }
            if (!graphExecutorAvailable) {
                String message = IOUtility.readResourceFully("/dot.error.txt");
                throw new SchemaCrawlerCommandLineException(message);
            }
        } else {
            graphExecutor = new GraphNoOpExecutor(this.graphOutputFormat);
        }
        return graphExecutor;
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = null;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler(OutputOptions outputOptions) throws SchemaCrawlerException {
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
        SchemaDotFormatter formatter = new SchemaDotFormatter(schemaTextDetailType, this.graphOptions, outputOptions, identifierQuoteString);
        return formatter;
    }

    private void loadGraphOptions() {
        if (this.graphOptions == null) {
            this.graphOptions = GraphOptionsBuilder.newGraphOptions(this.additionalConfiguration);
        }
        this.graphOutputFormat = GraphOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
    }
}

