/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.BaseCatalogDecorator;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.serialization.SerializableCatalog;

public final class XmlSerializedCatalog
extends BaseCatalogDecorator
implements SerializableCatalog {
    private static final long serialVersionUID = 5314326260124511414L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Catalog readCatalog(InputStream in) throws SchemaCrawlerException {
        Objects.requireNonNull(in, "No input stream provided");
        try (FSTObjectInput fstin = new FSTObjectInput(in);){
            Catalog catalog = (Catalog)fstin.readObject();
            return catalog;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SchemaCrawlerException("Cannot deserialize catalog", e);
        }
    }

    public XmlSerializedCatalog(Catalog catalog) {
        super(catalog);
    }

    public XmlSerializedCatalog(InputStream in) throws SchemaCrawlerException {
        this(XmlSerializedCatalog.readCatalog(in));
    }

    @Override
    public final <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public final <T> Optional<T> lookupAttribute(String name) {
        return Optional.of(this.getAttribute(name));
    }

    @Override
    public void save(OutputStream out) throws SchemaCrawlerException {
        Objects.requireNonNull(out, "No output stream provided");
        try (FSTObjectOutput fstout = new FSTObjectOutput(out);){
            fstout.writeObject((Object)this.catalog);
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Could not serialize catalog", e);
        }
    }
}

