/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.iosource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.tools.iosource.InputReader;
import schemacrawler.tools.iosource.InputResource;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public class FileInputResource
implements InputResource {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(FileInputResource.class.getName());
    private final Path inputFile;
    private final boolean allowEmptyFile;

    public static FileInputResource allowEmptyFileInputResource(Path filePath) throws IOException {
        return new FileInputResource(filePath, true);
    }

    public FileInputResource(Path filePath) throws IOException {
        this(filePath, false);
    }

    private FileInputResource(Path filePath, boolean allowEmptyFile) throws IOException {
        this.inputFile = Objects.requireNonNull(filePath, "No file path provided").normalize().toAbsolutePath();
        this.allowEmptyFile = allowEmptyFile;
        if (!allowEmptyFile && !IOUtility.isFileReadable(this.inputFile)) {
            IOException e = new IOException("Cannot read file, " + this.inputFile);
            LOGGER.log(Level.FINE, e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Path getInputFile() {
        return this.inputFile;
    }

    @Override
    public Reader openNewInputReader(Charset charset) throws IOException {
        Objects.requireNonNull(charset, "No input charset provided");
        if (this.allowEmptyFile && !Files.exists(this.inputFile, new LinkOption[0])) {
            return new StringReader("");
        }
        BufferedReader reader = Files.newBufferedReader(this.inputFile, charset);
        LOGGER.log(Level.INFO, new StringFormat("Opened input reader to file <%s>", this.inputFile));
        return new InputReader(this.getDescription(), reader, true);
    }

    public String toString() {
        return this.inputFile.toString();
    }
}

