/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import schemacrawler.schemacrawler.Options;
import schemacrawler.tools.iosource.CompressedFileInputResource;
import schemacrawler.tools.iosource.FileInputResource;
import schemacrawler.tools.iosource.FileOutputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.iosource.OutputResource;
import sf.util.ObjectToString;

public final class OutputOptions
implements Options {
    private final OutputResource outputResource;
    private final InputResource inputResource;
    private final String outputFormatValue;
    private final Charset inputEncodingCharset;
    private final Charset outputEncodingCharset;

    OutputOptions(InputResource inputResource, Charset inputEncodingCharset, OutputResource outputResource, Charset outputEncodingCharset, String outputFormatValue) {
        this.inputResource = Objects.requireNonNull(inputResource, "No input resource provided");
        this.inputEncodingCharset = Objects.requireNonNull(inputEncodingCharset, "No input encoding provided");
        this.outputResource = Objects.requireNonNull(outputResource, "No output resource provided");
        this.outputEncodingCharset = Objects.requireNonNull(outputEncodingCharset, "No output encoding provided");
        this.outputFormatValue = Objects.requireNonNull(outputFormatValue, "No output format value provided");
    }

    public Charset getInputCharset() {
        return this.inputEncodingCharset;
    }

    public Path getInputFile() {
        Path inputFile = this.inputResource instanceof FileInputResource ? ((FileInputResource)this.inputResource).getInputFile() : (this.inputResource instanceof CompressedFileInputResource ? ((CompressedFileInputResource)this.inputResource).getInputFile() : Paths.get(".", String.format("schemacrawler-%s.%s", UUID.randomUUID(), this.outputFormatValue)).normalize().toAbsolutePath());
        return inputFile;
    }

    public Charset getOutputCharset() {
        return this.outputEncodingCharset;
    }

    public Optional<Path> getOutputFile() {
        Path outputFile = this.outputResource instanceof FileOutputResource ? ((FileOutputResource)this.outputResource).getOutputFile() : null;
        return Optional.ofNullable(outputFile);
    }

    public String getOutputFormatValue() {
        return this.outputFormatValue;
    }

    public Reader openNewInputReader() throws IOException {
        return this.inputResource.openNewInputReader(this.inputEncodingCharset);
    }

    public Writer openNewOutputWriter() throws IOException {
        return this.openNewOutputWriter(false);
    }

    public Writer openNewOutputWriter(boolean appendOutput) throws IOException {
        return this.outputResource.openNewOutputWriter(this.getOutputCharset(), appendOutput);
    }

    public String toString() {
        return ObjectToString.toString(this);
    }

    InputResource getInputResource() {
        return this.inputResource;
    }

    OutputResource getOutputResource() {
        return this.outputResource;
    }
}

