/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.CompressedFileInputResource;
import schemacrawler.tools.iosource.CompressedFileOutputResource;
import schemacrawler.tools.iosource.ConsoleOutputResource;
import schemacrawler.tools.iosource.EmptyInputResource;
import schemacrawler.tools.iosource.FileInputResource;
import schemacrawler.tools.iosource.FileOutputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.iosource.OutputResource;
import schemacrawler.tools.iosource.WriterOutputResource;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import sf.util.IOUtility;
import sf.util.Utility;

public final class OutputOptionsBuilder
implements OptionsBuilder<OutputOptionsBuilder, OutputOptions> {
    private static final String SCHEMACRAWLER_DATA = "schemacrawler.data";
    private static final String SC_INPUT_ENCODING = "schemacrawler.encoding.input";
    private static final String SC_OUTPUT_ENCODING = "schemacrawler.encoding.output";
    private OutputResource outputResource;
    private InputResource inputResource;
    private String outputFormatValue;
    private Charset inputEncodingCharset;
    private Charset outputEncodingCharset;

    public static OutputOptionsBuilder builder() {
        return new OutputOptionsBuilder();
    }

    public static OutputOptionsBuilder builder(OutputOptions outputOptions) {
        return new OutputOptionsBuilder().fromOptions(outputOptions);
    }

    public static OutputOptions newOutputOptions() {
        return new OutputOptionsBuilder().toOptions();
    }

    public static OutputOptions newOutputOptions(Config config) {
        return new OutputOptionsBuilder().fromConfig(config).toOptions();
    }

    public static OutputOptions newOutputOptions(OutputFormat outputFormat, Path outputFile) {
        return new OutputOptionsBuilder().withOutputFormat(outputFormat).withOutputFile(outputFile).toOptions();
    }

    public static OutputOptions newOutputOptions(OutputFormat outputFormat, Writer writer) {
        return new OutputOptionsBuilder().withOutputFormat(outputFormat).withOutputWriter(writer).toOptions();
    }

    public static OutputOptions newOutputOptions(String outputFormatValue, Path outputFile) {
        return new OutputOptionsBuilder().withOutputFormatValue(outputFormatValue).withOutputFile(outputFile).toOptions();
    }

    public static OutputOptions newOutputOptions(String outputFormatValue, Writer writer) {
        return new OutputOptionsBuilder().withOutputFormatValue(outputFormatValue).withOutputWriter(writer).toOptions();
    }

    private OutputOptionsBuilder() {
    }

    public OutputOptionsBuilder fromConfig(Config config) {
        Config configProperties = config == null ? new Config() : config;
        this.withInputEncoding(configProperties.getStringValue(SC_INPUT_ENCODING, StandardCharsets.UTF_8.name())).withOutputEncoding(configProperties.getStringValue(SC_OUTPUT_ENCODING, StandardCharsets.UTF_8.name()));
        return this;
    }

    public OutputOptionsBuilder fromOptions(OutputOptions options) {
        if (options == null) {
            return this;
        }
        this.withInputEncoding(options.getInputCharset()).withOutputEncoding(options.getOutputCharset()).withOutputFormatValue(options.getOutputFormatValue());
        this.inputResource = options.getInputResource();
        this.outputResource = options.getOutputResource();
        return this;
    }

    @Override
    public Config toConfig() {
        Config config = new Config();
        config.setStringValue(SC_INPUT_ENCODING, this.inputEncodingCharset.name());
        config.setStringValue(SC_OUTPUT_ENCODING, this.outputEncodingCharset.name());
        return config;
    }

    @Override
    public OutputOptions toOptions() {
        if (this.inputResource == null) {
            this.withInputResource(this.createInputResource(this.outputFormatValue));
        }
        this.withInputEncoding(this.inputEncodingCharset);
        this.withOutputResource(this.outputResource);
        this.withOutputEncoding(this.inputEncodingCharset);
        if (Utility.isBlank(this.outputFormatValue)) {
            String fileExtension = this.outputResource instanceof FileOutputResource ? IOUtility.getFileExtension(((FileOutputResource)this.outputResource).getOutputFile()) : null;
            this.outputFormatValue = Utility.isBlank(fileExtension) ? TextOutputFormat.text.getFormat() : fileExtension;
        }
        return new OutputOptions(this.inputResource, this.inputEncodingCharset, this.outputResource, this.outputEncodingCharset, this.outputFormatValue);
    }

    public OutputOptionsBuilder withCompressedInputFile(Path inputFile) throws IOException {
        Objects.requireNonNull(inputFile, "No input file provided");
        this.inputResource = new CompressedFileInputResource(inputFile, SCHEMACRAWLER_DATA);
        return this;
    }

    public OutputOptionsBuilder withCompressedOutputFile(Path outputFile) throws IOException {
        Objects.requireNonNull(outputFile, "No output file provided");
        this.outputResource = new CompressedFileOutputResource(outputFile, SCHEMACRAWLER_DATA);
        return this;
    }

    public OutputOptionsBuilder withConsoleOutput() {
        this.outputResource = new ConsoleOutputResource();
        return this;
    }

    public OutputOptionsBuilder withInputEncoding(Charset inputCharset) {
        this.inputEncodingCharset = inputCharset == null ? StandardCharsets.UTF_8 : inputCharset;
        return this;
    }

    public OutputOptionsBuilder withInputEncoding(String inputEncoding) {
        try {
            this.inputEncodingCharset = Charset.forName(inputEncoding);
        }
        catch (IllegalArgumentException e) {
            this.inputEncodingCharset = StandardCharsets.UTF_8;
        }
        return this;
    }

    public OutputOptionsBuilder withInputFile(Path inputFile) throws IOException {
        Objects.requireNonNull(inputFile, "No input file provided");
        this.inputResource = new FileInputResource(inputFile);
        return this;
    }

    public OutputOptionsBuilder withInputResource(InputResource inputResource) {
        this.inputResource = inputResource == null ? new EmptyInputResource() : inputResource;
        return this;
    }

    public OutputOptionsBuilder withInputResourceName(String inputResourceName) {
        Objects.requireNonNull(inputResourceName, "No input resource name provided");
        this.inputResource = this.createInputResource(inputResourceName);
        return this;
    }

    public OutputOptionsBuilder withOutputEncoding(Charset outputCharset) {
        this.outputEncodingCharset = outputCharset == null ? StandardCharsets.UTF_8 : outputCharset;
        return this;
    }

    public OutputOptionsBuilder withOutputEncoding(String outputEncoding) {
        try {
            this.outputEncodingCharset = Charset.forName(outputEncoding);
        }
        catch (IllegalArgumentException e) {
            this.outputEncodingCharset = StandardCharsets.UTF_8;
        }
        return this;
    }

    public OutputOptionsBuilder withOutputFile(Path outputFile) {
        Objects.requireNonNull(outputFile, "No output file provided");
        this.outputResource = new FileOutputResource(outputFile);
        return this;
    }

    public OutputOptionsBuilder withOutputFormat(OutputFormat outputFormat) {
        this.outputFormatValue = Objects.requireNonNull(outputFormat, "No output format provided").getFormat();
        return this;
    }

    public OutputOptionsBuilder withOutputFormatValue(String outputFormatValue) {
        this.outputFormatValue = Objects.requireNonNull(outputFormatValue, "No output format value provided");
        return this;
    }

    public OutputOptionsBuilder withOutputResource(OutputResource outputResource) {
        if (outputResource == null) {
            if (this.outputFormatValue == null || TextOutputFormat.text.name().equals(this.outputFormatValue)) {
                this.outputResource = new ConsoleOutputResource();
            } else if (!(this.inputResource instanceof EmptyInputResource)) {
                this.outputResource = new ConsoleOutputResource();
            } else {
                String extension = "htmlx".equals(this.outputFormatValue) ? "svg.html" : this.outputFormatValue;
                Path randomOutputFile = Paths.get(".", String.format("schemacrawler-%s.%s", UUID.randomUUID(), extension)).normalize().toAbsolutePath();
                this.outputResource = new FileOutputResource(randomOutputFile);
            }
        } else {
            this.outputResource = outputResource;
        }
        return this;
    }

    public OutputOptionsBuilder withOutputWriter(Writer writer) {
        Objects.requireNonNull(writer, "No output writer provided");
        this.outputResource = new WriterOutputResource(writer);
        return this;
    }

    private InputResource createInputResource(String inputResourceName) {
        InputResource inputResource = null;
        try {
            Path filePath = Paths.get(inputResourceName, new String[0]);
            inputResource = new FileInputResource(filePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (inputResource == null) {
                inputResource = new ClasspathInputResource(inputResourceName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputResource == null) {
            inputResource = new EmptyInputResource();
        }
        return inputResource;
    }
}

