/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.util.Collection;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerInfo;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.Property;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.base.BaseTextOptions;
import schemacrawler.tools.text.utility.JsonFormattingHelper;
import schemacrawler.tools.text.utility.org.json.JSONArray;
import schemacrawler.tools.text.utility.org.json.JSONException;
import schemacrawler.tools.text.utility.org.json.JSONObject;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public abstract class BaseJsonFormatter<O extends BaseTextOptions>
extends BaseFormatter<O> {
    protected static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(BaseJsonFormatter.class.getName());
    protected final JSONObject jsonRoot = new JSONObject();

    protected BaseJsonFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        super(options, printVerboseDatabaseInfo, outputOptions, identifierQuoteString);
    }

    @Override
    public void begin() throws SchemaCrawlerException {
        if (!this.options.isNoHeader()) {
            this.formattingHelper.append("[").println();
        }
    }

    @Override
    public void end() throws SchemaCrawlerException {
        ((JsonFormattingHelper)this.formattingHelper).write(this.jsonRoot);
        if (this.options.isNoFooter()) {
            this.formattingHelper.append(",").println();
        } else {
            this.formattingHelper.append("]").println();
        }
        super.end();
    }

    @Override
    public void handle(CrawlInfo crawlInfo) throws SchemaCrawlerException {
        if (this.options.isNoSchemaCrawlerInfo() || crawlInfo == null) {
            return;
        }
        try {
            JSONObject jsonSchemaCrawlerHeaderInfo = new JSONObject();
            this.jsonRoot.put("schemaCrawlerHeaderInfo", jsonSchemaCrawlerHeaderInfo);
            jsonSchemaCrawlerHeaderInfo.put("crawlTimestamp", this.formatTimestamp(crawlInfo.getCrawlTimestamp()));
            jsonSchemaCrawlerHeaderInfo.put("runId", crawlInfo.getRunId());
            jsonSchemaCrawlerHeaderInfo.put("title", crawlInfo.getTitle());
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, new StringFormat("Error outputting SchemaCrawlerHeaderInfo: %s", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void handle(DatabaseInfo dbInfo) {
        if (!this.printVerboseDatabaseInfo || !this.options.isShowDatabaseInfo() || dbInfo == null) {
            return;
        }
        try {
            JSONObject jsonDbInfo = new JSONObject();
            this.jsonRoot.put("databaseInfo", jsonDbInfo);
            jsonDbInfo.put("databaseProductName", dbInfo.getProductName());
            jsonDbInfo.put("databaseProductVersion", dbInfo.getProductVersion());
            jsonDbInfo.put("databaseUserName", dbInfo.getUserName());
            Collection<Property> serverInfo = dbInfo.getServerInfo();
            if (this.printVerboseDatabaseInfo && !serverInfo.isEmpty()) {
                JSONArray jsonServerInfoProperties = new JSONArray();
                jsonDbInfo.put("serverInfo", jsonServerInfoProperties);
                for (Property property : serverInfo) {
                    JSONObject jsonServerInfoProperty = new JSONObject();
                    jsonServerInfoProperties.put(jsonServerInfoProperty);
                    jsonServerInfoProperty.put("name", property.getName());
                    jsonServerInfoProperty.put("description", property.getDescription());
                    jsonServerInfoProperty.put("value", property.getValue());
                }
            }
            Collection<DatabaseProperty> dbProperties = dbInfo.getProperties();
            if (this.printVerboseDatabaseInfo && !dbProperties.isEmpty()) {
                JSONArray jsonDbProperties = new JSONArray();
                jsonDbInfo.put("databaseProperties", jsonDbProperties);
                for (DatabaseProperty property : dbProperties) {
                    JSONObject jsonDbProperty = new JSONObject();
                    jsonDbProperties.put(jsonDbProperty);
                    jsonDbProperty.put("name", property.getName());
                    jsonDbProperty.put("description", property.getDescription());
                    jsonDbProperty.put("value", property.getValue());
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, new StringFormat("Error outputting DatabaseInfo: %s", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
        if (!this.printVerboseDatabaseInfo || !this.options.isShowJdbcDriverInfo() || driverInfo == null) {
            return;
        }
        try {
            JSONObject jsonDriverInfo = new JSONObject();
            this.jsonRoot.put("jdbcDriverInfo", jsonDriverInfo);
            jsonDriverInfo.put("driverName", driverInfo.getProductName());
            jsonDriverInfo.put("driverVersion", driverInfo.getProductVersion());
            jsonDriverInfo.put("driverClassName", driverInfo.getDriverClassName());
            jsonDriverInfo.put("url", driverInfo.getConnectionUrl());
            jsonDriverInfo.put("isJDBCCompliant", Boolean.toString(driverInfo.isJdbcCompliant()));
            Collection<JdbcDriverProperty> jdbcDriverProperties = driverInfo.getDriverProperties();
            if (!jdbcDriverProperties.isEmpty()) {
                JSONArray jsonJdbcDriverProperties = new JSONArray();
                jsonDriverInfo.put("jdbcDriverProperties", jsonJdbcDriverProperties);
                for (JdbcDriverProperty driverProperty : jdbcDriverProperties) {
                    jsonJdbcDriverProperties.put(this.printJdbcDriverProperty(driverProperty));
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, new StringFormat("Error outputting JdbcDriverInfo: %s", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
        if (!this.printVerboseDatabaseInfo || this.options.isNoSchemaCrawlerInfo() || schemaCrawlerInfo == null) {
            return;
        }
        try {
            JSONObject jsonSchemaCrawlerInfo = new JSONObject();
            this.jsonRoot.put("schemaCrawlerInfo", jsonSchemaCrawlerInfo);
            jsonSchemaCrawlerInfo.put("productName", schemaCrawlerInfo.getProductName());
            jsonSchemaCrawlerInfo.put("productVersion", schemaCrawlerInfo.getProductVersion());
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, new StringFormat("Error outputting SchemaCrawlerInfo: %s", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void handleHeaderEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleHeaderStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleInfoStart() throws SchemaCrawlerException {
    }

    private JSONObject printJdbcDriverProperty(JdbcDriverProperty driverProperty) {
        JSONObject jsonDriverProperty = new JSONObject();
        try {
            Collection<String> choices = driverProperty.getChoices();
            if (choices != null && !choices.isEmpty()) {
                jsonDriverProperty.put("choices", choices);
            }
            String value = driverProperty.getValue();
            jsonDriverProperty.put("name", driverProperty.getName());
            jsonDriverProperty.put("description", driverProperty.getDescription());
            jsonDriverProperty.put("required", driverProperty.isRequired());
            jsonDriverProperty.put("value", value);
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, new StringFormat("Error outputting JdbcDriverProperty: %s", e.getMessage()), (Throwable)e);
        }
        return jsonDriverProperty;
    }
}

