/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.schema.BaseForeignKey;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.WeakAssociationForeignKey;
import schemacrawler.tools.analysis.associations.WeakAssociationsUtility;
import schemacrawler.tools.analysis.counts.CountsUtility;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseDotFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.utility.html.Alignment;
import schemacrawler.tools.text.utility.html.TableRow;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import sf.util.Color;

public final class SchemaDotFormatter
extends BaseDotFormatter
implements SchemaTraversalHandler {
    private final boolean isVerbose;
    private final boolean isBrief;

    public SchemaDotFormatter(SchemaTextDetailType schemaTextDetailType, GraphOptions options, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions, identifierQuoteString);
        this.isVerbose = schemaTextDetailType == SchemaTextDetailType.details;
        this.isBrief = schemaTextDetailType == SchemaTextDetailType.brief;
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
    }

    @Override
    public void handle(Routine routine) {
    }

    @Override
    public void handle(Sequence sequence) {
    }

    @Override
    public void handle(Synonym synonym) {
    }

    @Override
    public void handle(Table table) {
        String tableName = ((GraphOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName(table) : this.identifiers.quoteFullName(table);
        String tableType = "[" + table.getTableType() + "]";
        Color tableNameBgColor = this.colorMap.getColor(table);
        int colspan = ((GraphOptions)this.options).isShowOrdinalNumbers() ? 3 : 2;
        this.formattingHelper.append("  /* ").append(table.getFullName()).append(" -=-=-=-=-=-=-=-=-=-=-=-=-=- */").println();
        this.formattingHelper.append("  \"").append(this.nodeId(table)).append("\" [").println();
        this.formattingHelper.append("    label=<").println();
        this.formattingHelper.append("      <table border=\"1\" cellborder=\"0\" cellspacing=\"0\" color=\"#888888\">").println();
        this.formattingHelper.append(new TableRow(TextOutputFormat.html).add(this.newTableCell(tableName, Alignment.left, true, tableNameBgColor, colspan)).add(this.newTableCell(tableType, Alignment.right, false, tableNameBgColor, 1)).toString()).println();
        this.printTableRemarks(table);
        this.printTableColumns(table.getColumns());
        if (this.isVerbose) {
            this.printTableColumns(new ArrayList<Column>(table.getHiddenColumns()));
        }
        this.printTableRowCount(table);
        this.formattingHelper.append("      </table>").println();
        this.formattingHelper.append("    >").println();
        this.formattingHelper.append("  ];").println();
        this.formattingHelper.println();
        this.printForeignKeys(table);
        this.printWeakAssociations(table);
        this.formattingHelper.println();
        this.formattingHelper.println();
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
    }

    private String arrowhead(MetaDataUtility.ForeignKeyCardinality connectivity) {
        switch (connectivity) {
            case unknown: {
                return "box";
            }
            case zero_one: {
                return "teeodot";
            }
            case zero_many: {
                return "crowodot";
            }
            case one_one: {
                return "teetee";
            }
        }
        return "box";
    }

    private String[] getPortIds(Column column, boolean isNewNode) {
        String[] portIds = new String[2];
        if (!isNewNode) {
            portIds[0] = String.format("\"%s\":\"%s.start\"", this.nodeId((DatabaseObject)column.getParent()), this.nodeId(column));
            portIds[1] = String.format("\"%s\":\"%s.end\"", this.nodeId((DatabaseObject)column.getParent()), this.nodeId(column));
        } else {
            String nodeId;
            portIds[0] = nodeId = this.printNewNode(column);
            portIds[1] = nodeId;
        }
        return portIds;
    }

    private String printColumnReference(String fkName, ColumnReference columnRef, MetaDataUtility.ForeignKeyCardinality fkCardinality, boolean isFkColumnFiltered) {
        boolean isForeignKey = columnRef instanceof ForeignKeyColumnReference;
        Column primaryKeyColumn = columnRef.getPrimaryKeyColumn();
        Column foreignKeyColumn = columnRef.getForeignKeyColumn();
        String[] pkPortIds = this.getPortIds(primaryKeyColumn, false);
        String[] fkPortIds = this.getPortIds(foreignKeyColumn, isFkColumnFiltered);
        GraphOptions graphOptions = (GraphOptions)this.options;
        String pkSymbol = graphOptions.isShowPrimaryKeyCardinality() ? "teetee" : "none";
        String fkSymbol = graphOptions.isShowForeignKeyCardinality() ? this.arrowhead(fkCardinality) : "none";
        String style = isForeignKey ? "solid" : "dashed";
        String associationName = ((GraphOptions)this.options).isHideForeignKeyNames() || !isForeignKey ? "" : fkName;
        return String.format("  %s:w -> %s:e [label=<%s> style=\"%s\" dir=\"both\" arrowhead=\"%s\" arrowtail=\"%s\"];%n", fkPortIds[0], pkPortIds[1], associationName, style, pkSymbol, fkSymbol);
    }

    private void printForeignKeys(Table table) {
        this.printForeignKeys(table, table.getForeignKeys());
    }

    private void printForeignKeys(Table table, Collection<? extends BaseForeignKey<?>> foreignKeys) {
        for (BaseForeignKey<?> foreignKey : foreignKeys) {
            MetaDataUtility.ForeignKeyCardinality fkCardinality = MetaDataUtility.findForeignKeyCardinality(foreignKey);
            for (ColumnReference columnRef : foreignKey) {
                Table referencedTable = (Table)columnRef.getForeignKeyColumn().getParent();
                boolean isForeignKeyFiltered = referencedTable.getAttribute("schemacrawler.table.no_grep_match", false);
                if (isForeignKeyFiltered) continue;
                boolean isFkColumnFiltered = referencedTable.getAttribute("schemacrawler.table.filtered_out", false);
                if (!table.equals(columnRef.getPrimaryKeyColumn().getParent())) continue;
                this.formattingHelper.append(this.printColumnReference(this.identifiers.quoteName(foreignKey.getName()), columnRef, fkCardinality, isFkColumnFiltered));
            }
        }
    }

    private String printNewNode(Column column) {
        String nodeId = "\"" + this.nodeId(column) + "\"";
        String columnName = ((GraphOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteShortName(column) : this.identifiers.quoteFullName(column);
        String columnNode = String.format("  %s [label=<%s>];%n", nodeId, columnName);
        this.formattingHelper.append(columnNode);
        return nodeId;
    }

    private void printTableColumnAutoIncremented(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isAutoIncremented()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        TableRow row = new TableRow(TextOutputFormat.html);
        if (((GraphOptions)this.options).isShowOrdinalNumbers()) {
            row.add(this.newTableCell("", Alignment.right, false, Color.white, 1));
        }
        row.add(this.newTableCell("", Alignment.left, false, Color.white, 1)).add(this.newTableCell(" ", Alignment.left, false, Color.white, 1)).add(this.newTableCell("auto-incremented", Alignment.left, false, Color.white, 1));
        this.formattingHelper.append(row.toString()).println();
    }

    private void printTableColumnGenerated(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isGenerated()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        TableRow row = new TableRow(TextOutputFormat.html);
        if (((GraphOptions)this.options).isShowOrdinalNumbers()) {
            row.add(this.newTableCell("", Alignment.right, false, Color.white, 1));
        }
        row.add(this.newTableCell("", Alignment.left, false, Color.white, 1)).add(this.newTableCell(" ", Alignment.left, false, Color.white, 1)).add(this.newTableCell("generated", Alignment.left, false, Color.white, 1));
        this.formattingHelper.append(row.toString()).println();
    }

    private void printTableColumnHidden(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isHidden()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        TableRow row = new TableRow(TextOutputFormat.html);
        if (((GraphOptions)this.options).isShowOrdinalNumbers()) {
            row.add(this.newTableCell("", Alignment.right, false, Color.white, 1));
        }
        row.add(this.newTableCell("", Alignment.left, false, Color.white, 1)).add(this.newTableCell(" ", Alignment.left, false, Color.white, 1)).add(this.newTableCell("hidden", Alignment.left, false, Color.white, 1));
        this.formattingHelper.append(row.toString()).println();
    }

    private void printTableColumnRemarks(Column column) {
        if (column == null || !column.hasRemarks() || ((GraphOptions)this.options).isHideRemarks()) {
            return;
        }
        TableRow remarksRow = new TableRow(TextOutputFormat.html);
        if (((GraphOptions)this.options).isShowOrdinalNumbers()) {
            remarksRow.add(this.newTableCell("", Alignment.right, false, Color.white, 1));
        }
        remarksRow.add(this.newTableCell("", Alignment.left, false, Color.white, 1)).add(this.newTableCell(" ", Alignment.left, false, Color.white, 1)).add(this.newTableCell(column.getRemarks(), Alignment.left, false, Color.white, 1));
        this.formattingHelper.append(remarksRow.toString()).println();
    }

    private void printTableColumns(List<Column> columns) {
        if (columns.isEmpty()) {
            return;
        }
        Collections.sort(columns, NamedObjectSort.getNamedObjectSort(((GraphOptions)this.options).isAlphabeticalSortForTableColumns()));
        for (Column column : columns) {
            if (this.isBrief && !this.isColumnSignificant(column)) continue;
            String columnTypeName = ((GraphOptions)this.options).isShowStandardColumnTypeNames() ? column.getColumnDataType().getJavaSqlType().getName() : column.getColumnDataType().getDatabaseSpecificTypeName();
            String columnType = columnTypeName + column.getWidth();
            String nullable = this.columnNullable(columnTypeName, column.isNullable());
            String columnDetails = columnType + nullable;
            boolean emphasize = column.isPartOfPrimaryKey();
            TableRow row = new TableRow(TextOutputFormat.html);
            if (((GraphOptions)this.options).isShowOrdinalNumbers()) {
                String ordinalNumberString = String.valueOf(column.getOrdinalPosition());
                row.add(this.newTableCell(ordinalNumberString, Alignment.right, false, Color.white, 1));
            }
            row.add(this.newTableCell(this.identifiers.quoteName(column.getName()), Alignment.left, emphasize, Color.white, 1)).add(this.newTableCell(" ", Alignment.left, false, Color.white, 1)).add(this.newTableCell(columnDetails, Alignment.left, false, Color.white, 1));
            row.firstCell().addAttribute("port", this.nodeId(column) + ".start");
            row.lastCell().addAttribute("port", this.nodeId(column) + ".end");
            this.formattingHelper.append(row.toString()).println();
            this.printTableColumnHidden(column);
            this.printTableColumnAutoIncremented(column);
            this.printTableColumnGenerated(column);
            this.printTableColumnRemarks(column);
        }
    }

    private void printTableRemarks(Table table) {
        if (table == null || !table.hasRemarks() || ((GraphOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.append(new TableRow(TextOutputFormat.html).add(this.newTableCell(table.getRemarks(), Alignment.left, false, Color.white, 3)).toString()).println();
    }

    private void printTableRowCount(Table table) {
        if (!((GraphOptions)this.options).isShowRowCounts() || table == null || !CountsUtility.hasRowCount(table)) {
            return;
        }
        this.formattingHelper.append(new TableRow(TextOutputFormat.html).add(this.newTableCell(CountsUtility.getRowCountMessage(table), Alignment.right, false, Color.white, 3)).toString()).println();
    }

    private void printWeakAssociations(Table table) {
        if (!((GraphOptions)this.options).isShowWeakAssociations()) {
            return;
        }
        Collection<WeakAssociationForeignKey> weakFks = WeakAssociationsUtility.getWeakAssociations(table);
        this.printForeignKeys(table, weakFks);
    }
}

