/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import java.io.PrintWriter;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.utility.BaseTextFormattingHelper;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import sf.util.Color;
import sf.util.Utility;

public class PlainTextFormattingHelper
extends BaseTextFormattingHelper {
    public PlainTextFormattingHelper(PrintWriter out, TextOutputFormat outputFormat) {
        super(out, outputFormat);
    }

    @Override
    public String createLeftArrow() {
        return "<--";
    }

    @Override
    public String createRightArrow() {
        return "-->";
    }

    @Override
    public String createWeakLeftArrow() {
        return "<~~";
    }

    @Override
    public String createWeakRightArrow() {
        return "~~>";
    }

    @Override
    public void writeDocumentEnd() {
    }

    @Override
    public void writeDocumentStart() {
    }

    @Override
    public void writeHeader(TextFormattingHelper.DocumentHeaderType type, String header) {
        if (!Utility.isBlank(header)) {
            String separator;
            String prefix;
            String defaultSeparator = PlainTextFormattingHelper.separator("=");
            if (type == null) {
                prefix = System.lineSeparator();
                separator = defaultSeparator;
            } else {
                switch (type) {
                    case title: {
                        prefix = System.lineSeparator();
                        separator = PlainTextFormattingHelper.separator("_");
                        break;
                    }
                    case section: {
                        prefix = "";
                        separator = PlainTextFormattingHelper.separator("-=-");
                        break;
                    }
                    default: {
                        prefix = System.lineSeparator();
                        separator = defaultSeparator;
                    }
                }
            }
            this.out.println(System.lineSeparator() + prefix + header + System.lineSeparator() + separator + prefix);
        }
    }

    @Override
    public void writeObjectEnd() {
        this.out.println();
    }

    @Override
    public void writeObjectNameRow(String id, String name, String description, Color backgroundColor) {
        this.writeNameRow(name, description);
        this.out.println(DASHED_SEPARATOR);
    }

    @Override
    public void writeObjectStart() {
    }
}

