/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.BaseConfigOptionsParser;
import schemacrawler.tools.text.schema.SchemaTextOptionsBuilder;

public final class AdditionalConfigOptionsParser
extends BaseConfigOptionsParser {
    public AdditionalConfigOptionsParser(Config config) {
        super(config);
    }

    @Override
    public void loadConfig() throws SchemaCrawlerException {
        boolean value;
        SchemaTextOptionsBuilder textOptionsBuilder = (SchemaTextOptionsBuilder)SchemaTextOptionsBuilder.builder().fromConfig(this.config);
        if (this.config.hasValue("noinfo")) {
            boolean noinfo = this.config.getBooleanValue("noinfo", true);
            textOptionsBuilder.noInfo(noinfo);
            this.consumeOption("noinfo");
        }
        if (this.config.hasValue("noremarks")) {
            boolean noremarks = this.config.getBooleanValue("noremarks", true);
            textOptionsBuilder.noRemarks(noremarks);
            this.consumeOption("noremarks");
        }
        if (this.config.hasValue("weakassociations")) {
            value = this.config.getBooleanValue("weakassociations", true);
            textOptionsBuilder.weakAssociations(value);
            this.consumeOption("weakassociations");
        }
        if (this.config.hasValue("sorttables")) {
            value = this.config.getBooleanValue("sorttables", true);
            textOptionsBuilder.sortTables(value);
            this.consumeOption("sorttables");
        }
        if (this.config.hasValue("sortcolumns")) {
            value = this.config.getBooleanValue("sortcolumns", true);
            textOptionsBuilder.sortTableColumns(value);
            this.consumeOption("sortcolumns");
        }
        if (this.config.hasValue("sortinout")) {
            value = this.config.getBooleanValue("sortinout", true);
            textOptionsBuilder.sortInOut(value);
            this.consumeOption("sortinout");
        }
        if (this.config.hasValue("portablenames")) {
            boolean portablenames = this.config.getBooleanValue("portablenames", true);
            textOptionsBuilder.portableNames(portablenames);
            this.consumeOption("portablenames");
        }
        this.config.putAll(textOptionsBuilder.toConfig());
        this.config.putAll(this.config);
    }
}

