/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.io.Console;
import java.util.logging.Level;
import schemacrawler.Version;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.BaseConfigOptionsParser;
import schemacrawler.tools.databaseconnector.SingleUseUserCredentials;
import schemacrawler.tools.databaseconnector.UserCredentials;
import sf.util.SchemaCrawlerLogger;

abstract class BaseDatabaseConnectionOptionsParser
extends BaseConfigOptionsParser {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(BaseDatabaseConnectionOptionsParser.class.getName());
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private UserCredentials userCredentials;

    BaseDatabaseConnectionOptionsParser(Config config) {
        super(config);
        this.normalizeOptionName(USER, "u");
        this.normalizeOptionName(PASSWORD, new String[0]);
    }

    public final UserCredentials getUserCredentials() {
        return this.userCredentials;
    }

    @Override
    public void loadConfig() throws SchemaCrawlerException {
        this.userCredentials = new SingleUseUserCredentials(this.getUser(), this.getPassword());
    }

    private String getPassword() {
        String password = this.config.hasValue(PASSWORD) ? this.config.getStringValue(PASSWORD, null) : this.promptForPassword();
        this.config.remove(PASSWORD);
        return password;
    }

    private String getUser() {
        String user = this.config.getStringValue(USER, null);
        this.config.remove(USER);
        return user;
    }

    private String promptForPassword() {
        Console console = System.console();
        if (console == null) {
            LOGGER.log(Level.WARNING, "System console is not available");
            return null;
        }
        try {
            console.format(Version.about(), new Object[0]);
            char[] passwordChars = console.readPassword("password: ", new Object[0]);
            return new String(passwordChars);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "System console is not available", (Throwable)e);
            return null;
        }
    }
}

