/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.freemarker;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.integration.freemarker.FreeMarkerRenderer;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.EmptyInputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;

public class FreeMarkerCommandProvider
implements CommandProvider {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(FreeMarkerCommandProvider.class.getName());

    @Override
    public String getDescription() {
        return "Render a Freemarker template against a schema";
    }

    @Override
    public InputResource getHelp() {
        String helpResource = "/help/FreeMarkerRenderer.txt";
        try {
            return new ClasspathInputResource("/help/FreeMarkerRenderer.txt");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Could not load help resource <%s>", "/help/FreeMarkerRenderer.txt"), (Throwable)e);
            return new EmptyInputResource();
        }
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return Arrays.asList("freemarker");
    }

    @Override
    public SchemaCrawlerCommand newSchemaCrawlerCommand(String command) {
        FreeMarkerRenderer scCommand = new FreeMarkerRenderer();
        return scCommand;
    }

    @Override
    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        return "freemarker".equals(command);
    }
}

