/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.util.ArrayList;
import java.util.Collection;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.ExecutableCommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.integration.graph.GraphRenderer;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import sf.util.Utility;

public final class GraphCommandProvider
extends ExecutableCommandProvider {
    private static Collection<String> supportedCommands = GraphCommandProvider.supportedCommands();

    private static Collection<String> supportedCommands() {
        ArrayList<String> supportedCommands = new ArrayList<String>();
        for (SchemaTextDetailType schemaTextDetailType : SchemaTextDetailType.values()) {
            supportedCommands.add(schemaTextDetailType.name());
        }
        return supportedCommands;
    }

    public GraphCommandProvider() {
        super(supportedCommands, "");
    }

    @Override
    public String getDescription() {
        return "Render a database diagram";
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return GraphCommandProvider.supportedCommands();
    }

    @Override
    public SchemaCrawlerCommand newSchemaCrawlerCommand(String command) throws SchemaCrawlerException {
        GraphRenderer scCommand = new GraphRenderer(command);
        return scCommand;
    }

    @Override
    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        if (Utility.isBlank(command) || outputOptions == null) {
            return false;
        }
        String format = outputOptions.getOutputFormatValue();
        GraphOutputFormat graphOutputFormat = GraphOutputFormat.fromFormat(format);
        boolean supportsSchemaCrawlerCommand = supportedCommands.contains(command) && (Utility.isBlank(format) || GraphOutputFormat.isSupportedFormat(format) && graphOutputFormat != GraphOutputFormat.htmlx);
        return supportsSchemaCrawlerCommand;
    }
}

