/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.nio.file.Path;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.graph.AbstractGraphProcessExecutor;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.integration.graph.GraphvizJavaExecutorUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

final class GraphJavaExecutor
extends AbstractGraphProcessExecutor {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphJavaExecutor.class.getName());

    GraphJavaExecutor(Path dotFile, Path outputFile, GraphOutputFormat graphOutputFormat) throws SchemaCrawlerException {
        super(dotFile, outputFile, graphOutputFormat);
    }

    @Override
    public Boolean call() {
        try {
            GraphvizJavaExecutorUtility.generateGraph(this.dotFile, this.outputFile, this.graphOutputFormat);
        }
        catch (SchemaCrawlerException e) {
            LOGGER.log(Level.INFO, String.format("Could not generate diagram from:%n%s", this.dotFile), (Throwable)e);
            return false;
        }
        LOGGER.log(Level.INFO, new StringFormat("Generated diagram <%s>", this.outputFile));
        return true;
    }

    @Override
    public boolean canGenerate() {
        return GraphvizJavaExecutorUtility.isGraphvizJavaAvailable(this.graphOutputFormat);
    }
}

